from tensorflow.python.framework import ops as ops
from tensorflow.python.util import tf_inspect as tf_inspect
from typing import Any

def adjoint(lin_op_a, name: Any | None = ...): ...
def cholesky(lin_op_a, name: Any | None = ...): ...
def matmul(lin_op_a, lin_op_b, name: Any | None = ...): ...
def solve(lin_op_a, lin_op_b, name: Any | None = ...): ...
def inverse(lin_op_a, name: Any | None = ...): ...

class RegisterAdjoint:
    def __init__(self, lin_op_cls_a) -> None: ...
    def __call__(self, adjoint_fn): ...

class RegisterCholesky:
    def __init__(self, lin_op_cls_a) -> None: ...
    def __call__(self, cholesky_fn): ...

class RegisterMatmul:
    def __init__(self, lin_op_cls_a, lin_op_cls_b) -> None: ...
    def __call__(self, matmul_fn): ...

class RegisterSolve:
    def __init__(self, lin_op_cls_a, lin_op_cls_b) -> None: ...
    def __call__(self, solve_fn): ...

class RegisterInverse:
    def __init__(self, lin_op_cls_a) -> None: ...
    def __call__(self, inverse_fn): ...
