from tensorflow.python.ops.gen_io_ops import *
from tensorflow.python.eager import context as context
from tensorflow.python.framework import dtypes as dtypes, ops as ops
from tensorflow.python.lib.io import python_io as python_io
from tensorflow.python.ops import gen_data_flow_ops as gen_data_flow_ops, gen_io_ops as gen_io_ops, gen_parsing_ops as gen_parsing_ops
from tensorflow.python.util import deprecation as deprecation
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

def read_file(filename, name: Any | None = ...): ...
def serialize_tensor(tensor, name: Any | None = ...): ...

class ReaderBase:
    def __init__(self, reader_ref, supports_serialize: bool = ...) -> None: ...
    @property
    def reader_ref(self): ...
    def read(self, queue, name: Any | None = ...): ...
    def read_up_to(self, queue, num_records, name: Any | None = ...): ...
    def num_records_produced(self, name: Any | None = ...): ...
    def num_work_units_completed(self, name: Any | None = ...): ...
    def serialize_state(self, name: Any | None = ...): ...
    def restore_state(self, state, name: Any | None = ...): ...
    @property
    def supports_serialize(self): ...
    def reset(self, name: Any | None = ...): ...

class WholeFileReader(ReaderBase):
    def __init__(self, name: Any | None = ...) -> None: ...

class TextLineReader(ReaderBase):
    def __init__(self, skip_header_lines: Any | None = ..., name: Any | None = ...) -> None: ...

class FixedLengthRecordReader(ReaderBase):
    def __init__(self, record_bytes, header_bytes: Any | None = ..., footer_bytes: Any | None = ..., hop_bytes: Any | None = ..., name: Any | None = ..., encoding: Any | None = ...) -> None: ...

class TFRecordReader(ReaderBase):
    def __init__(self, name: Any | None = ..., options: Any | None = ...) -> None: ...

class LMDBReader(ReaderBase):
    def __init__(self, name: Any | None = ..., options: Any | None = ...) -> None: ...

class IdentityReader(ReaderBase):
    def __init__(self, name: Any | None = ...) -> None: ...
