from absl.testing import parameterized
from tensorflow.python.eager import backprop as backprop, context as context
from tensorflow.python.framework import config as config, constant_op as constant_op, dtypes as dtypes, errors_impl as errors_impl, test_util as test_util
from tensorflow.python.ops import array_ops as array_ops, gen_image_ops as gen_image_ops, gradient_checker_v2 as gradient_checker_v2, image_ops as image_ops, math_ops as math_ops
from tensorflow.python.platform import test as test
from typing import Any

class ResizeNearestNeighborOpTestBase(test.TestCase):
    TYPES: Any
    def testShapeIsCorrectAfterOp(self) -> None: ...
    def testGradFromResizeToLargerInBothDims(self): ...
    def testGradFromResizeToSmallerInBothDims(self): ...
    def testCompareGpuVsCpu(self): ...

class ResizeBilinearOpTestBase(test.TestCase, parameterized.TestCase):
    def testGradients(self, batch_size, channel_count) -> None: ...
    def testTypes(self) -> None: ...
    def testGradOnUnsupportedType(self, use_tape) -> None: ...
    def testCompareGpuVsCpu(self, batch_size, channel_count) -> None: ...
    def testCompareGpuVsCpuFloat64(self) -> None: ...

class ResizeBicubicOpTestBase(test.TestCase, parameterized.TestCase):
    def testShapeIsCorrectAfterOp(self) -> None: ...
    def testGradFromResizeToLargerInBothDims(self): ...
    def testGradFromResizeToSmallerInBothDims(self): ...
    def testGradOnUnsupportedType(self, use_tape) -> None: ...

class ScaleAndTranslateOpTestBase(test.TestCase):
    def testGrads(self): ...
    def testIdentityGrads(self) -> None: ...

class CropAndResizeOpTestBase(test.TestCase):
    def testShapeIsCorrectAfterOp(self) -> None: ...
    def testGradRandomBoxes(self): ...

class RGBToHSVOpTestBase(test.TestCase):
    TYPES: Any
    def testShapeIsCorrectAfterOp(self) -> None: ...
    def testRGBToHSVGradSimpleCase(self): ...
    def testRGBToHSVGradRandomCase(self): ...
    def testRGBToHSVGradSpecialCaseRGreatest(self): ...
