from tensorflow.python.util.deprecation import deprecated_endpoints as deprecated_endpoints
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any, NamedTuple

def adjust_contrast(images, contrast_factor, min_value, max_value, name: Any | None = ...): ...

AdjustContrast: Any

def adjust_contrast_eager_fallback(images, contrast_factor, min_value, max_value, name, ctx): ...
def adjust_contrastv2(images, contrast_factor, name: Any | None = ...): ...

AdjustContrastv2: Any

def adjust_contrastv2_eager_fallback(images, contrast_factor, name, ctx): ...
def adjust_hue(images, delta, name: Any | None = ...): ...

AdjustHue: Any

def adjust_hue_eager_fallback(images, delta, name, ctx): ...
def adjust_saturation(images, scale, name: Any | None = ...): ...

AdjustSaturation: Any

def adjust_saturation_eager_fallback(images, scale, name, ctx): ...

class _CombinedNonMaxSuppressionOutput(NamedTuple):
    nmsed_boxes: Any
    nmsed_scores: Any
    nmsed_classes: Any
    valid_detections: Any

def combined_non_max_suppression(boxes, scores, max_output_size_per_class, max_total_size, iou_threshold, score_threshold, pad_per_class: bool = ..., clip_boxes: bool = ..., name: Any | None = ...): ...

CombinedNonMaxSuppression: Any

def combined_non_max_suppression_eager_fallback(boxes, scores, max_output_size_per_class, max_total_size, iou_threshold, score_threshold, pad_per_class, clip_boxes, name, ctx): ...
def crop_and_resize(image, boxes, box_ind, crop_size, method: str = ..., extrapolation_value: int = ..., name: Any | None = ...): ...

CropAndResize: Any

def crop_and_resize_eager_fallback(image, boxes, box_ind, crop_size, method, extrapolation_value, name, ctx): ...
def crop_and_resize_grad_boxes(grads, image, boxes, box_ind, method: str = ..., name: Any | None = ...): ...

CropAndResizeGradBoxes: Any

def crop_and_resize_grad_boxes_eager_fallback(grads, image, boxes, box_ind, method, name, ctx): ...
def crop_and_resize_grad_image(grads, boxes, box_ind, image_size, T, method: str = ..., name: Any | None = ...): ...

CropAndResizeGradImage: Any

def crop_and_resize_grad_image_eager_fallback(grads, boxes, box_ind, image_size, T, method, name, ctx): ...
def decode_and_crop_jpeg(contents, crop_window, channels: int = ..., ratio: int = ..., fancy_upscaling: bool = ..., try_recover_truncated: bool = ..., acceptable_fraction: int = ..., dct_method: str = ..., name: Any | None = ...): ...

DecodeAndCropJpeg: Any

def decode_and_crop_jpeg_eager_fallback(contents, crop_window, channels, ratio, fancy_upscaling, try_recover_truncated, acceptable_fraction, dct_method, name, ctx): ...
def decode_bmp(contents, channels: int = ..., name: Any | None = ...): ...

DecodeBmp: Any

def decode_bmp_eager_fallback(contents, channels, name, ctx): ...
def decode_gif(contents, name: Any | None = ...): ...

DecodeGif: Any

def decode_gif_eager_fallback(contents, name, ctx): ...
def decode_image(contents, channels: int = ..., dtype=..., expand_animations: bool = ..., name: Any | None = ...): ...

DecodeImage: Any

def decode_image_eager_fallback(contents, channels, dtype, expand_animations, name, ctx): ...
def decode_jpeg(contents, channels: int = ..., ratio: int = ..., fancy_upscaling: bool = ..., try_recover_truncated: bool = ..., acceptable_fraction: int = ..., dct_method: str = ..., name: Any | None = ...): ...

DecodeJpeg: Any

def decode_jpeg_eager_fallback(contents, channels, ratio, fancy_upscaling, try_recover_truncated, acceptable_fraction, dct_method, name, ctx): ...
def decode_png(contents, channels: int = ..., dtype=..., name: Any | None = ...): ...

DecodePng: Any

def decode_png_eager_fallback(contents, channels, dtype, name, ctx): ...
def draw_bounding_boxes(images, boxes, name: Any | None = ...): ...

DrawBoundingBoxes: Any

def draw_bounding_boxes_eager_fallback(images, boxes, name, ctx): ...
def draw_bounding_boxes_v2(images, boxes, colors, name: Any | None = ...): ...

DrawBoundingBoxesV2: Any

def draw_bounding_boxes_v2_eager_fallback(images, boxes, colors, name, ctx): ...
def encode_jpeg(image, format: str = ..., quality: int = ..., progressive: bool = ..., optimize_size: bool = ..., chroma_downsampling: bool = ..., density_unit: str = ..., x_density: int = ..., y_density: int = ..., xmp_metadata: str = ..., name: Any | None = ...): ...

EncodeJpeg: Any

def encode_jpeg_eager_fallback(image, format, quality, progressive, optimize_size, chroma_downsampling, density_unit, x_density, y_density, xmp_metadata, name, ctx): ...
def encode_jpeg_variable_quality(images, quality, name: Any | None = ...): ...

EncodeJpegVariableQuality: Any

def encode_jpeg_variable_quality_eager_fallback(images, quality, name, ctx): ...
def encode_png(image, compression: int = ..., name: Any | None = ...): ...

EncodePng: Any

def encode_png_eager_fallback(image, compression, name, ctx): ...
def extract_glimpse(input, size, offsets, centered: bool = ..., normalized: bool = ..., uniform_noise: bool = ..., noise: str = ..., name: Any | None = ...): ...

ExtractGlimpse: Any

def extract_glimpse_eager_fallback(input, size, offsets, centered, normalized, uniform_noise, noise, name, ctx): ...
def extract_glimpse_v2(input, size, offsets, centered: bool = ..., normalized: bool = ..., uniform_noise: bool = ..., noise: str = ..., name: Any | None = ...): ...

ExtractGlimpseV2: Any

def extract_glimpse_v2_eager_fallback(input, size, offsets, centered, normalized, uniform_noise, noise, name, ctx): ...
def extract_jpeg_shape(contents, output_type=..., name: Any | None = ...): ...

ExtractJpegShape: Any

def extract_jpeg_shape_eager_fallback(contents, output_type, name, ctx): ...

class _GenerateBoundingBoxProposalsOutput(NamedTuple):
    rois: Any
    roi_probabilities: Any

def generate_bounding_box_proposals(scores, bbox_deltas, image_info, anchors, nms_threshold, pre_nms_topn, min_size, post_nms_topn: int = ..., name: Any | None = ...): ...

GenerateBoundingBoxProposals: Any

def generate_bounding_box_proposals_eager_fallback(scores, bbox_deltas, image_info, anchors, nms_threshold, pre_nms_topn, min_size, post_nms_topn, name, ctx): ...
def hsv_to_rgb(images, name: Any | None = ...): ...

HSVToRGB: Any

def hsv_to_rgb_eager_fallback(images, name, ctx): ...
def image_projective_transform_v2(images, transforms, output_shape, interpolation, fill_mode: str = ..., name: Any | None = ...): ...

ImageProjectiveTransformV2: Any

def image_projective_transform_v2_eager_fallback(images, transforms, output_shape, interpolation, fill_mode, name, ctx): ...
def image_projective_transform_v3(images, transforms, output_shape, fill_value, interpolation, fill_mode: str = ..., name: Any | None = ...): ...

ImageProjectiveTransformV3: Any

def image_projective_transform_v3_eager_fallback(images, transforms, output_shape, fill_value, interpolation, fill_mode, name, ctx): ...
def non_max_suppression(boxes, scores, max_output_size, iou_threshold: float = ..., name: Any | None = ...): ...

NonMaxSuppression: Any

def non_max_suppression_eager_fallback(boxes, scores, max_output_size, iou_threshold, name, ctx): ...
def non_max_suppression_v2(boxes, scores, max_output_size, iou_threshold, name: Any | None = ...): ...

NonMaxSuppressionV2: Any

def non_max_suppression_v2_eager_fallback(boxes, scores, max_output_size, iou_threshold, name, ctx): ...
def non_max_suppression_v3(boxes, scores, max_output_size, iou_threshold, score_threshold, name: Any | None = ...): ...

NonMaxSuppressionV3: Any

def non_max_suppression_v3_eager_fallback(boxes, scores, max_output_size, iou_threshold, score_threshold, name, ctx): ...

class _NonMaxSuppressionV4Output(NamedTuple):
    selected_indices: Any
    valid_outputs: Any

def non_max_suppression_v4(boxes, scores, max_output_size, iou_threshold, score_threshold, pad_to_max_output_size: bool = ..., name: Any | None = ...): ...

NonMaxSuppressionV4: Any

def non_max_suppression_v4_eager_fallback(boxes, scores, max_output_size, iou_threshold, score_threshold, pad_to_max_output_size, name, ctx): ...

class _NonMaxSuppressionV5Output(NamedTuple):
    selected_indices: Any
    selected_scores: Any
    valid_outputs: Any

def non_max_suppression_v5(boxes, scores, max_output_size, iou_threshold, score_threshold, soft_nms_sigma, pad_to_max_output_size: bool = ..., name: Any | None = ...): ...

NonMaxSuppressionV5: Any

def non_max_suppression_v5_eager_fallback(boxes, scores, max_output_size, iou_threshold, score_threshold, soft_nms_sigma, pad_to_max_output_size, name, ctx): ...
def non_max_suppression_with_overlaps(overlaps, scores, max_output_size, overlap_threshold, score_threshold, name: Any | None = ...): ...

NonMaxSuppressionWithOverlaps: Any

def non_max_suppression_with_overlaps_eager_fallback(overlaps, scores, max_output_size, overlap_threshold, score_threshold, name, ctx): ...

class _QuantizedResizeBilinearOutput(NamedTuple):
    resized_images: Any
    out_min: Any
    out_max: Any

def quantized_resize_bilinear(images, size, min, max, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

QuantizedResizeBilinear: Any

def quantized_resize_bilinear_eager_fallback(images, size, min, max, align_corners, half_pixel_centers, name, ctx): ...
def rgb_to_hsv(images, name: Any | None = ...): ...

RGBToHSV: Any

def rgb_to_hsv_eager_fallback(images, name, ctx): ...
def random_crop(image, size, seed: int = ..., seed2: int = ..., name: Any | None = ...): ...

RandomCrop: Any

def random_crop_eager_fallback(image, size, seed, seed2, name, ctx): ...
def resize_area(images, size, align_corners: bool = ..., name: Any | None = ...): ...

ResizeArea: Any

def resize_area_eager_fallback(images, size, align_corners, name, ctx): ...
def resize_bicubic(images, size, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

ResizeBicubic: Any

def resize_bicubic_eager_fallback(images, size, align_corners, half_pixel_centers, name, ctx): ...
def resize_bicubic_grad(grads, original_image, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

ResizeBicubicGrad: Any

def resize_bicubic_grad_eager_fallback(grads, original_image, align_corners, half_pixel_centers, name, ctx): ...
def resize_bilinear(images, size, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

ResizeBilinear: Any

def resize_bilinear_eager_fallback(images, size, align_corners, half_pixel_centers, name, ctx): ...
def resize_bilinear_grad(grads, original_image, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

ResizeBilinearGrad: Any

def resize_bilinear_grad_eager_fallback(grads, original_image, align_corners, half_pixel_centers, name, ctx): ...
def resize_nearest_neighbor(images, size, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

ResizeNearestNeighbor: Any

def resize_nearest_neighbor_eager_fallback(images, size, align_corners, half_pixel_centers, name, ctx): ...
def resize_nearest_neighbor_grad(grads, size, align_corners: bool = ..., half_pixel_centers: bool = ..., name: Any | None = ...): ...

ResizeNearestNeighborGrad: Any

def resize_nearest_neighbor_grad_eager_fallback(grads, size, align_corners, half_pixel_centers, name, ctx): ...

class _SampleDistortedBoundingBoxOutput(NamedTuple):
    begin: Any
    size: Any
    bboxes: Any

def sample_distorted_bounding_box(image_size, bounding_boxes, seed: int = ..., seed2: int = ..., min_object_covered: float = ..., aspect_ratio_range=..., area_range=..., max_attempts: int = ..., use_image_if_no_bounding_boxes: bool = ..., name: Any | None = ...): ...

SampleDistortedBoundingBox: Any

def sample_distorted_bounding_box_eager_fallback(image_size, bounding_boxes, seed, seed2, min_object_covered, aspect_ratio_range, area_range, max_attempts, use_image_if_no_bounding_boxes, name, ctx): ...

class _SampleDistortedBoundingBoxV2Output(NamedTuple):
    begin: Any
    size: Any
    bboxes: Any

def sample_distorted_bounding_box_v2(image_size, bounding_boxes, min_object_covered, seed: int = ..., seed2: int = ..., aspect_ratio_range=..., area_range=..., max_attempts: int = ..., use_image_if_no_bounding_boxes: bool = ..., name: Any | None = ...): ...

SampleDistortedBoundingBoxV2: Any

def sample_distorted_bounding_box_v2_eager_fallback(image_size, bounding_boxes, min_object_covered, seed, seed2, aspect_ratio_range, area_range, max_attempts, use_image_if_no_bounding_boxes, name, ctx): ...
def scale_and_translate(images, size, scale, translation, kernel_type: str = ..., antialias: bool = ..., name: Any | None = ...): ...

ScaleAndTranslate: Any

def scale_and_translate_eager_fallback(images, size, scale, translation, kernel_type, antialias, name, ctx): ...
def scale_and_translate_grad(grads, original_image, scale, translation, kernel_type: str = ..., antialias: bool = ..., name: Any | None = ...): ...

ScaleAndTranslateGrad: Any

def scale_and_translate_grad_eager_fallback(grads, original_image, scale, translation, kernel_type, antialias, name, ctx): ...

class _StatelessSampleDistortedBoundingBoxOutput(NamedTuple):
    begin: Any
    size: Any
    bboxes: Any

def stateless_sample_distorted_bounding_box(image_size, bounding_boxes, min_object_covered, seed, aspect_ratio_range=..., area_range=..., max_attempts: int = ..., use_image_if_no_bounding_boxes: bool = ..., name: Any | None = ...): ...

StatelessSampleDistortedBoundingBox: Any

def stateless_sample_distorted_bounding_box_eager_fallback(image_size, bounding_boxes, min_object_covered, seed, aspect_ratio_range, area_range, max_attempts, use_image_if_no_bounding_boxes, name, ctx): ...
