import abc
from typing import Any

class _BaseDistribution: ...

class _DistributionMeta(abc.ABCMeta):
    def __new__(mcs, classname, baseclasses, attrs): ...

class ReparameterizationType:
    def __init__(self, rep_type) -> None: ...
    def __eq__(self, other): ...

FULLY_REPARAMETERIZED: Any
NOT_REPARAMETERIZED: Any

class Distribution(_BaseDistribution):
    def __init__(self, dtype, reparameterization_type, validate_args, allow_nan_stats, parameters: Any | None = ..., graph_parents: Any | None = ..., name: Any | None = ...) -> None: ...
    @classmethod
    def param_shapes(cls, sample_shape, name: str = ...): ...
    @classmethod
    def param_static_shapes(cls, sample_shape): ...
    @property
    def name(self): ...
    @property
    def dtype(self): ...
    @property
    def parameters(self): ...
    @property
    def reparameterization_type(self): ...
    @property
    def allow_nan_stats(self): ...
    @property
    def validate_args(self): ...
    def copy(self, **override_parameters_kwargs): ...
    def batch_shape_tensor(self, name: str = ...): ...
    @property
    def batch_shape(self): ...
    def event_shape_tensor(self, name: str = ...): ...
    @property
    def event_shape(self): ...
    def is_scalar_event(self, name: str = ...): ...
    def is_scalar_batch(self, name: str = ...): ...
    def sample(self, sample_shape=..., seed: Any | None = ..., name: str = ...): ...
    def log_prob(self, value, name: str = ...): ...
    def prob(self, value, name: str = ...): ...
    def log_cdf(self, value, name: str = ...): ...
    def cdf(self, value, name: str = ...): ...
    def log_survival_function(self, value, name: str = ...): ...
    def survival_function(self, value, name: str = ...): ...
    def entropy(self, name: str = ...): ...
    def mean(self, name: str = ...): ...
    def quantile(self, value, name: str = ...): ...
    def variance(self, name: str = ...): ...
    def stddev(self, name: str = ...): ...
    def covariance(self, name: str = ...): ...
    def mode(self, name: str = ...): ...
    def cross_entropy(self, other, name: str = ...): ...
    def kl_divergence(self, other, name: str = ...): ...
