import abc
from typing import Any

class _Mapping:
    def __new__(cls, x: Any | None = ..., y: Any | None = ..., ildj_map: Any | None = ..., kwargs: Any | None = ...): ...
    @property
    def x_key(self): ...
    @property
    def y_key(self): ...
    def merge(self, x: Any | None = ..., y: Any | None = ..., ildj_map: Any | None = ..., kwargs: Any | None = ..., mapping: Any | None = ...): ...

class Bijector(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def __init__(self, graph_parents: Any | None = ..., is_constant_jacobian: bool = ..., validate_args: bool = ..., dtype: Any | None = ..., forward_min_event_ndims: Any | None = ..., inverse_min_event_ndims: Any | None = ..., name: Any | None = ...): ...
    @property
    def graph_parents(self): ...
    @property
    def forward_min_event_ndims(self): ...
    @property
    def inverse_min_event_ndims(self): ...
    @property
    def is_constant_jacobian(self): ...
    @property
    def validate_args(self): ...
    @property
    def dtype(self): ...
    @property
    def name(self): ...
    def forward_event_shape_tensor(self, input_shape, name: str = ...): ...
    def forward_event_shape(self, input_shape): ...
    def inverse_event_shape_tensor(self, output_shape, name: str = ...): ...
    def inverse_event_shape(self, output_shape): ...
    def forward(self, x, name: str = ...): ...
    def inverse(self, y, name: str = ...): ...
    def inverse_log_det_jacobian(self, y, event_ndims, name: str = ...): ...
    def forward_log_det_jacobian(self, x, event_ndims, name: str = ...): ...
