from tensorflow.python.ops.gen_control_flow_ops import *
import abc
from tensorflow.core.framework import attr_value_pb2 as attr_value_pb2
from tensorflow.core.protobuf import control_flow_pb2 as control_flow_pb2
from tensorflow.python.eager import context as context
from tensorflow.python.framework import composite_tensor as composite_tensor, constant_op as constant_op, dtypes as dtypes, errors as errors, ops as ops, tensor_shape as tensor_shape, tensor_spec as tensor_spec, tensor_util as tensor_util, type_spec as type_spec
from tensorflow.python.ops import array_ops as array_ops, gen_array_ops as gen_array_ops, gen_control_flow_ops as gen_control_flow_ops, gen_functional_ops as gen_functional_ops, gen_logging_ops as gen_logging_ops, gen_math_ops as gen_math_ops, math_ops as math_ops, tensor_array_ops as tensor_array_ops
from tensorflow.python.util import compat as compat, deprecation as deprecation, dispatch as dispatch, nest as nest, tf_should_use as tf_should_use
from tensorflow.python.util.lazy_loader import LazyLoader as LazyLoader
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

cond_v2: Any
while_v2: Any
def_function: Any

def Assert(condition, data, summarize: Any | None = ..., name: Any | None = ...): ...
def exit(tensor, name: Any | None = ...): ...
def switch(data, pred, dtype: Any | None = ..., name: Any | None = ...): ...
def merge(inputs, name: Any | None = ...): ...

class ControlFlowContext(metaclass=abc.ABCMeta):
    def __init__(self, values_def: Any | None = ..., import_scope: Any | None = ...) -> None: ...
    @property
    def name(self): ...
    @property
    def outer_context(self): ...
    @property
    def grad_state(self) -> None: ...
    @property
    def back_prop(self) -> None: ...
    @abc.abstractmethod
    def to_control_flow_context_def(self, context_def, export_scope: Any | None = ...): ...
    def AddName(self, name) -> None: ...
    def Enter(self) -> None: ...
    def Exit(self) -> None: ...
    def EnterGradientColocation(self, op, gradient_uid) -> None: ...
    def ExitGradientColocation(self, op, gradient_uid) -> None: ...
    def ExitResult(self, result): ...
    def GetWhileContext(self): ...
    def AddInnerOp(self, op) -> None: ...
    def GetControlPivot(self) -> None: ...
    def IsWhileContext(self): ...
    def IsCondContext(self): ...
    def IsXLAContext(self): ...

class CondContext(ControlFlowContext):
    def __init__(self, pred: Any | None = ..., pivot: Any | None = ..., branch: Any | None = ..., name: str = ..., context_def: Any | None = ..., import_scope: Any | None = ...) -> None: ...
    @property
    def pred(self): ...
    @property
    def pivot(self): ...
    @property
    def branch(self): ...
    @property
    def grad_state(self): ...
    @property
    def back_prop(self): ...
    def GetControlPivot(self): ...
    def to_proto(self, export_scope: Any | None = ...): ...
    @staticmethod
    def from_proto(context_def, import_scope: Any | None = ...): ...
    def to_control_flow_context_def(self, context_def, export_scope: Any | None = ...) -> None: ...
    def AddValue(self, val): ...
    def AddOp(self, op) -> None: ...
    def BuildCondBranch(self, fn): ...
    def IsCondContext(self): ...

def cond(pred, true_fn: Any | None = ..., false_fn: Any | None = ..., strict: bool = ..., name: Any | None = ..., fn1: Any | None = ..., fn2: Any | None = ...): ...
def cond_for_tf_v2(pred, true_fn: Any | None = ..., false_fn: Any | None = ..., name: Any | None = ...): ...

class WhileContext(ControlFlowContext):
    def __init__(self, maximum_iterations: Any | None = ..., parallel_iterations: int = ..., back_prop: bool = ..., swap_memory: bool = ..., name: str = ..., grad_state: Any | None = ..., context_def: Any | None = ..., import_scope: Any | None = ...) -> None: ...
    @property
    def maximum_iterations(self): ...
    @property
    def parallel_iterations(self): ...
    @property
    def back_prop(self): ...
    @property
    def swap_memory(self): ...
    @property
    def pivot(self): ...
    @property
    def loop_enters(self): ...
    @property
    def loop_exits(self): ...
    @property
    def grad_state(self): ...
    def to_proto(self, export_scope: Any | None = ...): ...
    def to_control_flow_context_def(self, context_def, export_scope: Any | None = ...) -> None: ...
    @staticmethod
    def from_proto(context_def, import_scope: Any | None = ...): ...
    def GetWhileContext(self): ...
    def GetControlPivot(self): ...
    def AddValue(self, val): ...
    def AddOp(self, op) -> None: ...
    def AddForwardLoopCounter(self, outer_grad_state): ...
    def AddBackpropLoopCounter(self, count, outer_grad_state): ...
    def AddBackpropAccumulator(self, op, grad): ...
    def AddBackpropIndexedSlicesAccumulator(self, op, grad): ...
    def BuildLoop(self, pred, body, loop_vars, shape_invariants, return_same_structure): ...
    def IsWhileContext(self): ...

def while_loop_v2(cond, body, loop_vars, shape_invariants: Any | None = ..., parallel_iterations: int = ..., back_prop: bool = ..., swap_memory: bool = ..., maximum_iterations: Any | None = ..., name: Any | None = ...): ...
def while_loop(cond, body, loop_vars, shape_invariants: Any | None = ..., parallel_iterations: int = ..., back_prop: bool = ..., swap_memory: bool = ..., name: Any | None = ..., maximum_iterations: Any | None = ..., return_same_structure: bool = ...): ...
def with_dependencies(dependencies, output_tensor, name: Any | None = ...): ...
def group(*inputs, **kwargs): ...
def tuple_v2(tensors, control_inputs: Any | None = ..., name: Any | None = ...): ...
def tuple(tensors, name: Any | None = ..., control_inputs: Any | None = ...): ...
def case_v2(pred_fn_pairs, default: Any | None = ..., exclusive: bool = ..., strict: bool = ..., name: str = ...): ...
def case(pred_fn_pairs, default: Any | None = ..., exclusive: bool = ..., strict: bool = ..., name: str = ...): ...
def switch_case(branch_index, branch_fns, default: Any | None = ..., name: str = ...): ...
def execute_fn_for_device(device_branch_fns, default_fn, name: str = ...): ...

class XLAControlFlowContext(ControlFlowContext):
    def __init__(self) -> None: ...
    def to_control_flow_context_def(self, context_def, export_scope: Any | None = ...) -> None: ...
    def IsXLAContext(self): ...
    def AddOp(self, _) -> None: ...
    def AddValue(self, x): ...
    def RequiresUniqueFunctionRetracing(self): ...

def get_enclosing_xla_context(): ...
def from_control_flow_context_def(context_def, import_scope: Any | None = ...): ...
