import abc
from tensorflow.python.keras.saving.saved_model import json_utils as json_utils, utils as utils
from tensorflow.python.training.tracking import tracking as tracking
from typing import Any

class SavedModelSaver(metaclass=abc.ABCMeta):
    obj: Any
    def __init__(self, obj) -> None: ...
    @property
    @abc.abstractmethod
    def object_identifier(self): ...
    @property
    def tracking_metadata(self): ...
    def list_extra_dependencies_for_serialization(self, serialization_cache): ...
    def list_functions_for_serialization(self, serialization_cache): ...
    @property
    @abc.abstractmethod
    def python_properties(self): ...
    @abc.abstractmethod
    def objects_to_serialize(self, serialization_cache): ...
    @abc.abstractmethod
    def functions_to_serialize(self, serialization_cache): ...
