import abc
from tensorflow.python.distribute import central_storage_strategy as central_storage_strategy, parameter_server_strategy as parameter_server_strategy, parameter_server_strategy_v2 as parameter_server_strategy_v2
from tensorflow.python.eager import backprop as backprop, context as context
from tensorflow.python.framework import dtypes as dtypes, ops as ops, tensor_util as tensor_util
from tensorflow.python.keras import backend as backend, initializers as initializers
from tensorflow.python.keras.engine import base_layer_utils as base_layer_utils
from tensorflow.python.keras.optimizer_v2 import learning_rate_schedule as learning_rate_schedule
from tensorflow.python.keras.utils import generic_utils as generic_utils, layer_utils as layer_utils, tf_inspect as tf_inspect, tf_utils as tf_utils
from tensorflow.python.ops import array_ops as array_ops, control_flow_ops as control_flow_ops, gen_resource_variable_ops as gen_resource_variable_ops, gradients as gradients, math_ops as math_ops
from tensorflow.python.saved_model import revived_types as revived_types
from tensorflow.python.training.tracking import base as trackable
from tensorflow.python.util import nest as nest
from tensorflow.python.util.tf_export import keras_export as keras_export
from typing import Any

class NullContextmanager:
    def __init__(self, *args, **kwargs) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, type_arg, value_arg, traceback_arg): ...

def name_scope_only_in_function_or_graph(name): ...

class OptimizerV2(trackable.Trackable, metaclass=abc.ABCMeta):
    gradient_aggregator: Any
    gradient_transformers: Any
    def __init__(self, name, gradient_aggregator: Any | None = ..., gradient_transformers: Any | None = ..., **kwargs) -> None: ...
    @property
    def clipnorm(self): ...
    @property
    def global_clipnorm(self): ...
    @clipnorm.setter
    def clipnorm(self, val) -> None: ...
    @global_clipnorm.setter
    def global_clipnorm(self, val) -> None: ...
    @property
    def clipvalue(self): ...
    @clipvalue.setter
    def clipvalue(self, val) -> None: ...
    def minimize(self, loss, var_list, grad_loss: Any | None = ..., name: Any | None = ..., tape: Any | None = ...): ...
    def apply_gradients(self, grads_and_vars, name: Any | None = ..., experimental_aggregate_gradients: bool = ...): ...
    def get_gradients(self, loss, params): ...
    def get_updates(self, loss, params): ...
    def __getattribute__(self, name): ...
    def __dir__(self): ...
    def __setattr__(self, name, value) -> None: ...
    def get_slot_names(self): ...
    def add_slot(self, var, slot_name, initializer: str = ..., shape: Any | None = ...): ...
    def get_slot(self, var, slot_name): ...
    @property
    def iterations(self): ...
    @iterations.setter
    def iterations(self, variable) -> None: ...
    @abc.abstractmethod
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ...): ...
    def variables(self): ...
    @property
    def weights(self): ...
    def get_weights(self): ...
    def set_weights(self, weights) -> None: ...
    def add_weight(self, name, shape, dtype: Any | None = ..., initializer: str = ..., trainable: Any | None = ..., synchronization=..., aggregation=...): ...

class RestoredOptimizer(OptimizerV2):
    def __init__(self) -> None: ...
    def get_config(self) -> None: ...
