from tensorflow.python.eager import backprop as backprop, context as context
from tensorflow.python.framework import constant_op as constant_op, dtypes as dtypes, ops as ops, sparse_tensor as sparse_tensor, tensor_shape as tensor_shape
from tensorflow.python.keras import activations as activations, constraints as constraints, initializers as initializers, regularizers as regularizers
from tensorflow.python.keras.engine import keras_tensor as keras_tensor
from tensorflow.python.keras.engine.base_layer import Layer as Layer
from tensorflow.python.keras.engine.input_spec import InputSpec as InputSpec
from tensorflow.python.keras.utils import control_flow_util as control_flow_util, conv_utils as conv_utils, generic_utils as generic_utils, tf_inspect as tf_inspect, tf_utils as tf_utils
from tensorflow.python.ops import array_ops as array_ops, embedding_ops as embedding_ops, gen_math_ops as gen_math_ops, math_ops as math_ops, nn as nn, nn_ops as nn_ops, sparse_ops as sparse_ops, standard_ops as standard_ops, variable_scope as variable_scope
from tensorflow.python.ops.ragged import ragged_getitem as ragged_getitem, ragged_tensor as ragged_tensor
from tensorflow.python.platform import tf_logging as tf_logging
from tensorflow.python.util import dispatch as dispatch, nest as nest, tf_decorator as tf_decorator
from tensorflow.python.util.tf_export import get_canonical_name_for_symbol as get_canonical_name_for_symbol, get_symbol_from_name as get_symbol_from_name, keras_export as keras_export
from typing import Any

class Masking(Layer):
    supports_masking: bool
    mask_value: Any
    def __init__(self, mask_value: float = ..., **kwargs) -> None: ...
    def compute_mask(self, inputs, mask: Any | None = ...): ...
    def call(self, inputs): ...
    def compute_output_shape(self, input_shape): ...
    def get_config(self): ...

class Dropout(Layer):
    rate: Any
    noise_shape: Any
    seed: Any
    supports_masking: bool
    def __init__(self, rate, noise_shape: Any | None = ..., seed: Any | None = ..., **kwargs) -> None: ...
    def call(self, inputs, training: Any | None = ...): ...
    def compute_output_shape(self, input_shape): ...
    def get_config(self): ...

class SpatialDropout1D(Dropout):
    input_spec: Any
    def __init__(self, rate, **kwargs) -> None: ...

class SpatialDropout2D(Dropout):
    data_format: Any
    input_spec: Any
    def __init__(self, rate, data_format: Any | None = ..., **kwargs) -> None: ...

class SpatialDropout3D(Dropout):
    data_format: Any
    input_spec: Any
    def __init__(self, rate, data_format: Any | None = ..., **kwargs) -> None: ...

class Activation(Layer):
    supports_masking: bool
    activation: Any
    def __init__(self, activation, **kwargs) -> None: ...
    def call(self, inputs): ...
    def compute_output_shape(self, input_shape): ...
    def get_config(self): ...

class Reshape(Layer):
    target_shape: Any
    def __init__(self, target_shape, **kwargs) -> None: ...
    def compute_output_shape(self, input_shape): ...
    def call(self, inputs): ...
    def get_config(self): ...

class Permute(Layer):
    dims: Any
    input_spec: Any
    def __init__(self, dims, **kwargs) -> None: ...
    def compute_output_shape(self, input_shape): ...
    def call(self, inputs): ...
    def get_config(self): ...

class Flatten(Layer):
    data_format: Any
    input_spec: Any
    def __init__(self, data_format: Any | None = ..., **kwargs) -> None: ...
    def call(self, inputs): ...
    def compute_output_shape(self, input_shape): ...
    def get_config(self): ...

class RepeatVector(Layer):
    n: Any
    input_spec: Any
    def __init__(self, n, **kwargs) -> None: ...
    def compute_output_shape(self, input_shape): ...
    def call(self, inputs): ...
    def get_config(self): ...

class Lambda(Layer):
    arguments: Any
    function: Any
    supports_masking: bool
    mask: Any
    def __init__(self, function, output_shape: Any | None = ..., mask: Any | None = ..., arguments: Any | None = ..., **kwargs) -> None: ...
    def compute_output_shape(self, input_shape): ...
    def call(self, inputs, mask: Any | None = ..., training: Any | None = ...): ...
    def compute_mask(self, inputs, mask: Any | None = ...): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ...): ...

class Dense(Layer):
    units: Any
    activation: Any
    use_bias: Any
    kernel_initializer: Any
    bias_initializer: Any
    kernel_regularizer: Any
    bias_regularizer: Any
    kernel_constraint: Any
    bias_constraint: Any
    input_spec: Any
    supports_masking: bool
    def __init__(self, units, activation: Any | None = ..., use_bias: bool = ..., kernel_initializer: str = ..., bias_initializer: str = ..., kernel_regularizer: Any | None = ..., bias_regularizer: Any | None = ..., activity_regularizer: Any | None = ..., kernel_constraint: Any | None = ..., bias_constraint: Any | None = ..., **kwargs) -> None: ...
    kernel: Any
    bias: Any
    built: bool
    def build(self, input_shape) -> None: ...
    def call(self, inputs): ...
    def compute_output_shape(self, input_shape): ...
    def get_config(self): ...

class ActivityRegularization(Layer):
    supports_masking: bool
    l1: Any
    l2: Any
    def __init__(self, l1: float = ..., l2: float = ..., **kwargs) -> None: ...
    def compute_output_shape(self, input_shape): ...
    def get_config(self): ...

class TFOpLambda(Layer):
    function: Any
    symbol: Any
    call: Any
    def __init__(self, function, **kwargs): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ...): ...

class KerasOpDispatcher(dispatch.GlobalOpDispatcher):
    def handle(self, op, args, kwargs): ...

class SlicingOpLambda(TFOpLambda):
    call: Any
    def __init__(self, function, **kwargs): ...

class TFSlicingOpDispatcher(dispatch.OpDispatcher):
    op: Any
    def __init__(self, op) -> None: ...
    def handle(self, args, kwargs): ...

class InstanceProperty(Layer):
    attr_name: Any
    def __init__(self, attr_name, **kwargs) -> None: ...
    def call(self, obj): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ...): ...

class InstanceMethod(InstanceProperty):
    def call(self, obj, args, kwargs): ...

class ClassMethod(Layer):
    cls_ref: Any
    method_name: Any
    cls_symbol: Any
    def __init__(self, cls_ref, method_name, **kwargs) -> None: ...
    def call(self, args, kwargs): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ...): ...

class TFClassMethodDispatcher(dispatch.OpDispatcher):
    cls: Any
    method_name: Any
    def __init__(self, cls, method_name) -> None: ...
    def handle(self, args, kwargs): ...
