import abc
from tensorflow.core.framework import graph_pb2 as graph_pb2
from tensorflow.python import tf2 as tf2
from tensorflow.python.data.experimental.ops import cardinality as cardinality
from tensorflow.python.data.ops import dataset_ops as dataset_ops, iterator_ops as iterator_ops
from tensorflow.python.eager import context as context
from tensorflow.python.framework import composite_tensor as composite_tensor, dtypes as dtypes, errors as errors, ops as ops, smart_cond as smart_cond, sparse_tensor as sparse_tensor, tensor_spec as tensor_spec, tensor_util as tensor_util
from tensorflow.python.keras import backend as backend, losses as losses
from tensorflow.python.keras.utils import data_utils as data_utils, generic_utils as generic_utils, losses_utils as losses_utils, tf_inspect as tf_inspect
from tensorflow.python.ops import array_ops as array_ops, gen_array_ops as gen_array_ops, math_ops as math_ops, sparse_ops as sparse_ops
from tensorflow.python.ops.ragged import ragged_tensor as ragged_tensor, ragged_tensor_value as ragged_tensor_value
from tensorflow.python.util import nest as nest
from typing import Any

def is_composite_or_composite_value(tensor): ...

class Aggregator(metaclass=abc.ABCMeta):
    use_steps: Any
    num_samples: Any
    steps: Any
    batch_size: Any
    results: Any
    def __init__(self, use_steps, num_samples: Any | None = ..., steps: Any | None = ..., batch_size: Any | None = ...) -> None: ...
    @abc.abstractmethod
    def create(self, batch_outs): ...
    @abc.abstractmethod
    def aggregate(self, batch_outs, batch_start: Any | None = ..., batch_end: Any | None = ...): ...
    @abc.abstractmethod
    def finalize(self): ...

class MetricsAggregator(Aggregator):
    def __init__(self, use_steps, num_samples: Any | None = ..., steps: Any | None = ...) -> None: ...
    results: Any
    def create(self, batch_outs) -> None: ...
    def aggregate(self, batch_outs, batch_start: Any | None = ..., batch_end: Any | None = ...) -> None: ...
    def finalize(self) -> None: ...

class ConcatAggregator(Aggregator):
    composite: Any
    def __init__(self, batch_size) -> None: ...
    def create(self, batch_element) -> None: ...
    def aggregate(self, batch_element, batch_start: Any | None = ..., batch_end: Any | None = ...) -> None: ...
    results: Any
    def finalize(self) -> None: ...

def get_copy_pool(): ...

class SliceAggregator(Aggregator):
    def __init__(self, num_samples, batch_size) -> None: ...
    results: Any
    def create(self, batch_element) -> None: ...
    def aggregate(self, batch_element, batch_start, batch_end) -> None: ...
    def finalize(self) -> None: ...

class OutputsAggregator(Aggregator):
    def create(self, batch_outs): ...
    def aggregate(self, batch_outs, batch_start: Any | None = ..., batch_end: Any | None = ...) -> None: ...
    results: Any
    def finalize(self) -> None: ...

def get_progbar(model, count_mode, include_metrics: bool = ...): ...
def check_num_samples(ins, batch_size: Any | None = ..., steps: Any | None = ..., steps_name: str = ...): ...
def standardize_single_array(x, expected_shape: Any | None = ...): ...
def get_composite_shape(tensor): ...
def standardize_input_data(data, names, shapes: Any | None = ..., check_batch_axis: bool = ..., exception_prefix: str = ...): ...
def standardize_sample_or_class_weights(x_weight, output_names, weight_type): ...
def standardize_class_weights(class_weight, output_names): ...
def standardize_sample_weights(sample_weight, output_names): ...
def check_array_lengths(inputs, targets, weights: Any | None = ...): ...
def check_loss_and_target_compatibility(targets, loss_fns, output_shapes) -> None: ...
def collect_per_output_metric_info(metrics, output_names, output_shapes, loss_fns, from_serialized: bool = ..., is_weighted: bool = ...): ...
def batch_shuffle(index_array, batch_size): ...
def standardize_weights(y, sample_weight: Any | None = ..., class_weight: Any | None = ..., sample_weight_mode: Any | None = ...): ...
def has_symbolic_tensors(ls): ...
def has_tensors(ls): ...
def get_metric_name(metric, weighted: bool = ...): ...
def get_metric_function(metric, output_shape: Any | None = ..., loss_fn: Any | None = ...): ...
def call_metric_function(metric_fn, y_true, y_pred: Any | None = ..., weights: Any | None = ..., mask: Any | None = ...): ...
def get_loss_function(loss): ...
def validate_dataset_input(x, y, sample_weight, validation_split: Any | None = ...) -> None: ...
def validate_input_types(inp, orig_inp, allow_dict: bool = ..., field_name: str = ...) -> None: ...
def check_generator_arguments(y: Any | None = ..., sample_weight: Any | None = ..., validation_split: Any | None = ...) -> None: ...
def check_steps_argument(input_data, steps, steps_name): ...
def cast_single_tensor(x, dtype: Any | None = ...): ...
def cast_if_floating_dtype_and_mismatch(targets, outputs): ...
def cast_if_floating_dtype(x, dtype: Any | None = ...): ...
def cast_to_model_input_dtypes(x, model): ...
def prepare_sample_weight_modes(training_endpoints, sample_weight_mode) -> None: ...
def prepare_loss_functions(loss, output_names): ...
def prepare_loss_weights(training_endpoints, loss_weights: Any | None = ...) -> None: ...
def is_feature_layer(layer): ...
def is_eager_dataset_or_iterator(data): ...
def get_dataset_graph_def(dataset): ...
def verify_dataset_shuffled(x): ...
def is_dataset_or_iterator(data): ...
def get_iterator(dataset): ...
def initialize_iterator(iterator) -> None: ...
def extract_tensors_from_dataset(dataset): ...
def unpack_iterator_input(iterator): ...
def infer_steps_for_dataset(model, dataset, steps, epochs: int = ..., steps_name: str = ...): ...

class ModelInputs:
    def __init__(self, inputs) -> None: ...
    def get_input_names(self): ...
    def get_symbolic_inputs(self, return_single_as_list: bool = ...): ...
    def as_dict(self) -> None: ...
    def as_list(self): ...

def generic_output_names(outputs_list): ...
def should_run_validation(validation_freq, epoch): ...
def split_training_and_validation_data(x, y, sample_weights, validation_split): ...
def unpack_validation_data(validation_data, raise_if_ambiguous: bool = ...): ...

class TrainingLoop:
    def fit(self, model, x: Any | None = ..., y: Any | None = ..., batch_size: Any | None = ..., epochs: int = ..., verbose: int = ..., callbacks: Any | None = ..., validation_split: float = ..., validation_data: Any | None = ..., shuffle: bool = ..., class_weight: Any | None = ..., sample_weight: Any | None = ..., initial_epoch: int = ..., steps_per_epoch: Any | None = ..., validation_steps: Any | None = ..., validation_freq: int = ..., **kwargs) -> None: ...
    def evaluate(self, model, x: Any | None = ..., y: Any | None = ..., batch_size: Any | None = ..., verbose: int = ..., sample_weight: Any | None = ..., steps: Any | None = ..., callbacks: Any | None = ..., **kwargs) -> None: ...
    def predict(self, model, x, batch_size: Any | None = ..., verbose: int = ..., steps: Any | None = ..., callbacks: Any | None = ..., **kwargs) -> None: ...
