import abc
from tensorflow.python.data.experimental.ops import cardinality as cardinality
from tensorflow.python.data.ops import dataset_ops as dataset_ops, iterator_ops as iterator_ops
from tensorflow.python.distribute import input_lib as input_lib
from tensorflow.python.eager import context as context
from tensorflow.python.framework import dtypes as dtypes, errors as errors, ops as ops, smart_cond as smart_cond, sparse_tensor as sparse_tensor, tensor_shape as tensor_shape
from tensorflow.python.keras import backend as backend
from tensorflow.python.keras.engine import training_utils as training_utils
from tensorflow.python.keras.utils import data_utils as data_utils, dataset_creator as dataset_creator, tf_utils as tf_utils
from tensorflow.python.ops import array_ops as array_ops, math_ops as math_ops, random_ops as random_ops, script_ops as script_ops
from tensorflow.python.util import nest as nest
from tensorflow.python.util.tf_export import keras_export as keras_export
from typing import Any

class DataAdapter(metaclass=abc.ABCMeta):
    @staticmethod
    def can_handle(x, y: Any | None = ...) -> None: ...
    @abc.abstractmethod
    def __init__(self, x, y: Any | None = ..., **kwargs): ...
    @abc.abstractmethod
    def get_dataset(self): ...
    @abc.abstractmethod
    def get_size(self): ...
    @abc.abstractmethod
    def batch_size(self): ...
    def representative_batch_size(self): ...
    @abc.abstractmethod
    def has_partial_batch(self): ...
    @abc.abstractmethod
    def partial_batch_size(self): ...
    @abc.abstractmethod
    def should_recreate_iterator(self): ...
    def get_samples(self): ...
    def on_epoch_end(self) -> None: ...

class TensorLikeDataAdapter(DataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, x, y: Any | None = ..., sample_weights: Any | None = ..., sample_weight_modes: Any | None = ..., batch_size: Any | None = ..., epochs: int = ..., steps: Any | None = ..., shuffle: bool = ..., **kwargs): ...
    def slice_inputs(self, indices_dataset, inputs): ...
    def get_dataset(self): ...
    def get_size(self): ...
    def batch_size(self): ...
    def has_partial_batch(self): ...
    def partial_batch_size(self): ...
    def should_recreate_iterator(self): ...

class GenericArrayLikeDataAdapter(TensorLikeDataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, *args, **kwargs) -> None: ...
    def slice_inputs(self, indices_dataset, inputs): ...

class DatasetCreatorAdapter(DataAdapter):
    dataset_creator: Any
    steps: Any
    strategy: Any
    def __init__(self, x, y, steps: Any | None = ..., distribution_strategy: Any | None = ..., **kwargs) -> None: ...
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def should_recreate_iterator(self): ...
    def get_size(self) -> None: ...
    def get_dataset(self): ...
    def batch_size(self) -> None: ...
    def has_partial_batch(self) -> None: ...
    def partial_batch_size(self) -> None: ...

class CompositeTensorDataAdapter(DataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, x, y: Any | None = ..., sample_weights: Any | None = ..., sample_weight_modes: Any | None = ..., batch_size: Any | None = ..., steps: Any | None = ..., shuffle: bool = ..., **kwargs) -> None: ...
    def get_dataset(self): ...
    def get_size(self): ...
    def batch_size(self): ...
    def has_partial_batch(self): ...
    def partial_batch_size(self): ...
    def should_recreate_iterator(self): ...

class ListsOfScalarsDataAdapter(DataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, x, y: Any | None = ..., sample_weights: Any | None = ..., sample_weight_modes: Any | None = ..., batch_size: Any | None = ..., shuffle: bool = ..., **kwargs) -> None: ...
    def get_dataset(self): ...
    def get_size(self): ...
    def batch_size(self): ...
    def has_partial_batch(self): ...
    def partial_batch_size(self): ...
    def should_recreate_iterator(self): ...

class DatasetAdapter(DataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, x, y: Any | None = ..., sample_weights: Any | None = ..., steps: Any | None = ..., **kwargs) -> None: ...
    def get_dataset(self): ...
    def get_size(self) -> None: ...
    def batch_size(self) -> None: ...
    def has_partial_batch(self): ...
    def partial_batch_size(self) -> None: ...
    def should_recreate_iterator(self): ...

class GeneratorDataAdapter(DataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, x, y: Any | None = ..., sample_weights: Any | None = ..., workers: int = ..., use_multiprocessing: bool = ..., max_queue_size: int = ..., model: Any | None = ..., **kwargs): ...
    def get_dataset(self): ...
    def get_size(self) -> None: ...
    def batch_size(self) -> None: ...
    def representative_batch_size(self): ...
    def has_partial_batch(self): ...
    def partial_batch_size(self) -> None: ...
    def should_recreate_iterator(self): ...

class KerasSequenceAdapter(GeneratorDataAdapter):
    @staticmethod
    def can_handle(x, y: Any | None = ...): ...
    def __init__(self, x, y: Any | None = ..., sample_weights: Any | None = ..., shuffle: bool = ..., workers: int = ..., use_multiprocessing: bool = ..., max_queue_size: int = ..., model: Any | None = ..., **kwargs) -> None: ...
    def get_size(self): ...
    def should_recreate_iterator(self): ...
    def on_epoch_end(self) -> None: ...

ALL_ADAPTER_CLS: Any

def select_data_adapter(x, y): ...
def is_none_or_empty(inputs): ...
def broadcast_sample_weight_modes(target_structure, sample_weight_modes): ...

class DataHandler:
    def __init__(self, x, y: Any | None = ..., sample_weight: Any | None = ..., batch_size: Any | None = ..., steps_per_epoch: Any | None = ..., initial_epoch: int = ..., epochs: int = ..., shuffle: bool = ..., class_weight: Any | None = ..., max_queue_size: int = ..., workers: int = ..., use_multiprocessing: bool = ..., model: Any | None = ..., steps_per_execution: Any | None = ..., distribute: bool = ...) -> None: ...
    def enumerate_epochs(self) -> None: ...
    def sync(self) -> None: ...
    def catch_stop_iteration(self) -> None: ...
    def steps(self) -> None: ...
    @property
    def step_increment(self): ...
    @property
    def inferred_steps(self): ...
    @property
    def should_sync(self): ...

class _ClusterCoordinatorDataHandler(DataHandler):
    def __init__(self, x, y: Any | None = ..., **kwargs) -> None: ...
    def sync(self) -> None: ...

def get_data_handler(*args, **kwargs): ...
def expand_1d(data): ...
def train_validation_split(arrays, validation_split): ...
def unpack_x_y_sample_weight(data): ...
def pack_x_y_sample_weight(x, y: Any | None = ..., sample_weight: Any | None = ...): ...
def single_batch_iterator(strategy, x, y: Any | None = ..., sample_weight: Any | None = ..., class_weight: Any | None = ...): ...
