import abc
from tensorflow.python.framework import composite_tensor as composite_tensor, dtypes as dtypes, extension_type_field as extension_type_field, immutable_dict as immutable_dict, ops as ops, tensor_shape as tensor_shape, tensor_spec as tensor_spec, type_spec as type_spec
from tensorflow.python.ops import array_ops as array_ops, composite_tensor_ops as composite_tensor_ops, gen_math_ops as gen_math_ops, math_ops as math_ops
from tensorflow.python.saved_model import nested_structure_coder as nested_structure_coder
from tensorflow.python.util import nest as nest, tf_decorator as tf_decorator, tf_inspect as tf_inspect
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

class ExtensionTypeMetaclass(abc.ABCMeta):
    def __init__(cls, name, bases, namespace) -> None: ...

class ExtensionType(composite_tensor.CompositeTensor, metaclass=ExtensionTypeMetaclass):
    def __init__(self, *args, **kwargs) -> None: ...
    def __setattr__(self, name, value) -> None: ...
    def __delattr__(self, name) -> None: ...
    def __getattr__(self, name): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __validate__(self) -> None: ...

def pack(value): ...
def unpack(value): ...
def is_packed(value): ...

class ExtensionTypeSpec(type_spec.TypeSpec):
    def __reduce__(self): ...
    @classmethod
    def from_value(cls, value): ...
    def __setattr__(self, name, value) -> None: ...
    def __delattr__(self, name) -> None: ...
    def __validate__(self) -> None: ...

class ExtensionTypeBatchEncoder(type_spec.TypeSpecBatchEncoder):
    def batch(self, spec, batch_size): ...
    def unbatch(self, spec): ...
    def encode(self, spec, value, minimum_rank: int = ...): ...
    def decode(self, spec, encoded_value): ...
    def encoding_specs(self, spec): ...

class BatchableExtensionTypeSpec(ExtensionTypeSpec, type_spec.BatchableTypeSpec):
    __batch_encoder__: Any

class BatchableExtensionType(ExtensionType): ...

class AnonymousExtensionType(ExtensionType):
    def __init__(self, **fields) -> None: ...
    def __setattr__(self, name, value) -> None: ...
    def __delattr__(self, name) -> None: ...

class AnonymousExtensionTypeSpec(ExtensionTypeSpec):
    def __init__(self, **fields) -> None: ...
    value_type: Any
    def __setattr__(self, name, value) -> None: ...
    def __delattr__(self, name) -> None: ...

def reinterpret(value, new_type): ...
