import abc
from tensorflow.python.data.ops import readers as readers
from tensorflow.python.eager import context as context
from tensorflow.python.feature_column import feature_column as fc_old
from tensorflow.python.framework import dtypes as dtypes, ops as ops, tensor_shape as tensor_shape
from tensorflow.python.ops import array_ops as array_ops, check_ops as check_ops, control_flow_ops as control_flow_ops, embedding_ops as embedding_ops, init_ops as init_ops, lookup_ops as lookup_ops, math_ops as math_ops, parsing_ops as parsing_ops, sparse_ops as sparse_ops, string_ops as string_ops, variable_scope as variable_scope, variables as variables
from tensorflow.python.platform import gfile as gfile
from tensorflow.python.training import checkpoint_utils as checkpoint_utils
from tensorflow.python.training.tracking import data_structures as data_structures, tracking as tracking
from tensorflow.python.util import deprecation as deprecation, nest as nest, tf_inspect as tf_inspect
from tensorflow.python.util.compat import collections_abc as collections_abc
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any, NamedTuple

class StateManager:
    def create_variable(self, feature_column, name, shape, dtype: Any | None = ..., trainable: bool = ..., use_resource: bool = ..., initializer: Any | None = ...) -> None: ...
    def add_variable(self, feature_column, var) -> None: ...
    def get_variable(self, feature_column, name) -> None: ...
    def add_resource(self, feature_column, name, resource) -> None: ...
    def has_resource(self, feature_column, name) -> None: ...
    def get_resource(self, feature_column, name) -> None: ...

class _StateManagerImpl(StateManager):
    def __init__(self, layer, trainable): ...
    def create_variable(self, feature_column, name, shape, dtype: Any | None = ..., trainable: bool = ..., use_resource: bool = ..., initializer: Any | None = ...): ...
    def get_variable(self, feature_column, name): ...
    def add_resource(self, feature_column, resource_name, resource) -> None: ...
    def has_resource(self, feature_column, resource_name): ...
    def get_resource(self, feature_column, resource_name): ...

def make_parse_example_spec_v2(feature_columns): ...
def embedding_column(categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., use_safe_embedding_lookup: bool = ...): ...
def shared_embedding_columns(categorical_columns, dimension, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., use_safe_embedding_lookup: bool = ...): ...
def shared_embedding_columns_v2(categorical_columns, dimension, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., use_safe_embedding_lookup: bool = ...): ...
def numeric_column(key, shape=..., default_value: Any | None = ..., dtype=..., normalizer_fn: Any | None = ...): ...
def bucketized_column(source_column, boundaries): ...
def categorical_column_with_hash_bucket(key, hash_bucket_size, dtype=...): ...
def categorical_column_with_vocabulary_file(key, vocabulary_file, vocabulary_size: Any | None = ..., num_oov_buckets: int = ..., default_value: Any | None = ..., dtype=...): ...
def categorical_column_with_vocabulary_file_v2(key, vocabulary_file, vocabulary_size: Any | None = ..., dtype=..., default_value: Any | None = ..., num_oov_buckets: int = ..., file_format: Any | None = ...): ...
def categorical_column_with_vocabulary_list(key, vocabulary_list, dtype: Any | None = ..., default_value: int = ..., num_oov_buckets: int = ...): ...
def categorical_column_with_identity(key, num_buckets, default_value: Any | None = ...): ...
def indicator_column(categorical_column): ...
def weighted_categorical_column(categorical_column, weight_feature_key, dtype=...): ...
def crossed_column(keys, hash_bucket_size, hash_key: Any | None = ...): ...

class FeatureColumn(metaclass=abc.ABCMeta):
    @property
    @abc.abstractmethod
    def name(self): ...
    def __lt__(self, other): ...
    def __gt__(self, other): ...
    @abc.abstractmethod
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    @abc.abstractmethod
    def parse_example_spec(self): ...
    def create_state(self, state_manager) -> None: ...
    @property
    @abc.abstractmethod
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class DenseColumn(FeatureColumn, metaclass=abc.ABCMeta):
    @property
    @abc.abstractmethod
    def variable_shape(self): ...
    @abc.abstractmethod
    def get_dense_tensor(self, transformation_cache, state_manager): ...

def is_feature_column_v2(feature_columns): ...

class CategoricalColumn(FeatureColumn, metaclass=abc.ABCMeta):

    class IdWeightPair(NamedTuple):
        id_tensor: Any
        weight_tensor: Any
    @property
    @abc.abstractmethod
    def num_buckets(self): ...
    @abc.abstractmethod
    def get_sparse_tensors(self, transformation_cache, state_manager): ...

class SequenceDenseColumn(FeatureColumn, metaclass=abc.ABCMeta):

    class TensorSequenceLengthPair(NamedTuple):
        dense_tensor: Any
        sequence_length: Any
    @abc.abstractmethod
    def get_sequence_dense_tensor(self, transformation_cache, state_manager): ...

class FeatureTransformationCache:
    def __init__(self, features) -> None: ...
    def get(self, key, state_manager, training: Any | None = ...): ...

class NumericColumn(DenseColumn, fc_old._DenseColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def variable_shape(self): ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class BucketizedColumn(DenseColumn, CategoricalColumn, fc_old._DenseColumn, fc_old._CategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def variable_shape(self): ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class EmbeddingColumn(DenseColumn, SequenceDenseColumn, fc_old._DenseColumn, fc_old._SequenceDenseColumn):
    def __new__(cls, categorical_column, dimension, combiner, initializer, ckpt_to_load_from, tensor_name_in_ckpt, max_norm, trainable, use_safe_embedding_lookup: bool = ...): ...
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def variable_shape(self): ...
    def create_state(self, state_manager) -> None: ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...
    def get_sequence_dense_tensor(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class SharedEmbeddingColumnCreator(tracking.AutoTrackable):
    def __init__(self, dimension, initializer, ckpt_to_load_from, tensor_name_in_ckpt, num_buckets, trainable, name: str = ..., use_safe_embedding_lookup: bool = ...) -> None: ...
    def __call__(self, categorical_column, combiner, max_norm): ...
    @property
    def embedding_weights(self): ...
    @property
    def dimension(self): ...

class SharedEmbeddingColumn(DenseColumn, SequenceDenseColumn, fc_old._DenseColumn, fc_old._SequenceDenseColumn):
    def __new__(cls, categorical_column, shared_embedding_column_creator, combiner, max_norm, use_safe_embedding_lookup: bool = ...): ...
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def variable_shape(self): ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...
    def get_sequence_dense_tensor(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...

class HashedCategoricalColumn(CategoricalColumn, fc_old._CategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class VocabularyFileCategoricalColumn(CategoricalColumn, fc_old._CategoricalColumn):
    def __new__(cls, key, vocabulary_file, vocabulary_size, num_oov_buckets, dtype, default_value, file_format: Any | None = ...): ...
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class VocabularyListCategoricalColumn(CategoricalColumn, fc_old._CategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class IdentityCategoricalColumn(CategoricalColumn, fc_old._CategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class WeightedCategoricalColumn(CategoricalColumn, fc_old._CategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    @property
    def num_buckets(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class CrossedColumn(CategoricalColumn, fc_old._CategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class IndicatorColumn(DenseColumn, SequenceDenseColumn, fc_old._DenseColumn, fc_old._SequenceDenseColumn):
    @property
    def name(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def parse_example_spec(self): ...
    @property
    def variable_shape(self): ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...
    def get_sequence_dense_tensor(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...

class SequenceCategoricalColumn(CategoricalColumn, fc_old._SequenceCategoricalColumn):
    @property
    def name(self): ...
    @property
    def parse_example_spec(self): ...
    def transform_feature(self, transformation_cache, state_manager): ...
    @property
    def num_buckets(self): ...
    def get_sparse_tensors(self, transformation_cache, state_manager): ...
    @property
    def parents(self): ...
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ..., columns_by_name: Any | None = ...): ...
