from tensorflow.core.framework import summary_pb2 as summary_pb2
from tensorflow.python import pywrap_tfe as pywrap_tfe
from tensorflow.python.client import pywrap_tf_session as pywrap_tf_session
from tensorflow.python.framework import c_api_util as c_api_util
from tensorflow.python.util import compat as compat
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any, NamedTuple

class _MetricMethod(NamedTuple):
    create: Any
    delete: Any
    get_cell: Any

class Metric:
    def __init__(self, metric_name, metric_methods, label_length, *args) -> None: ...
    def __del__(self) -> None: ...
    def get_cell(self, *labels): ...

class CounterCell:
    def __init__(self, cell) -> None: ...
    def increase_by(self, value) -> None: ...
    def value(self): ...

class Counter(Metric):
    def __init__(self, name, description, *labels) -> None: ...
    def get_cell(self, *labels): ...

class IntGaugeCell:
    def __init__(self, cell) -> None: ...
    def set(self, value) -> None: ...
    def value(self): ...

class IntGauge(Metric):
    def __init__(self, name, description, *labels) -> None: ...
    def get_cell(self, *labels): ...

class StringGaugeCell:
    def __init__(self, cell) -> None: ...
    def set(self, value) -> None: ...
    def value(self): ...

class StringGauge(Metric):
    def __init__(self, name, description, *labels) -> None: ...
    def get_cell(self, *labels): ...

class BoolGaugeCell:
    def __init__(self, cell) -> None: ...
    def set(self, value) -> None: ...
    def value(self): ...

class BoolGauge(Metric):
    def __init__(self, name, description, *labels) -> None: ...
    def get_cell(self, *labels): ...

class SamplerCell:
    def __init__(self, cell) -> None: ...
    def add(self, value) -> None: ...
    def value(self): ...

class Buckets:
    buckets: Any
    def __init__(self, buckets) -> None: ...
    def __del__(self) -> None: ...

class ExponentialBuckets(Buckets):
    def __init__(self, scale, growth_factor, bucket_count) -> None: ...

class Sampler(Metric):
    def __init__(self, name, buckets, description, *labels) -> None: ...
    def get_cell(self, *labels): ...

class MonitoredTimer:
    cell: Any
    def __init__(self, cell) -> None: ...
    t: Any
    def __enter__(self): ...
    def __exit__(self, exception_type, exception_value, traceback) -> None: ...

def monitored_timer(cell): ...
