from tensorflow.core.framework import attr_value_pb2 as attr_value_pb2
from tensorflow.python.distribute.parallel_device import parallel_device as parallel_device
from tensorflow.python.eager import context as context, lift_to_graph as lift_to_graph, monitoring as monitoring
from tensorflow.python.framework import composite_tensor as composite_tensor, errors as errors, ops as ops
from tensorflow.python.ops import array_ops as array_ops, control_flow_ops as control_flow_ops, control_flow_util as control_flow_util, math_ops as math_ops, random_ops as random_ops, resource_variable_ops as resource_variable_ops
from tensorflow.python.profiler import trace as trace
from tensorflow.python.types import core as core
from tensorflow.python.util import deprecation as deprecation, nest as nest, object_identity as object_identity, tf_decorator as tf_decorator, traceback_utils as traceback_utils
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

FREQUENT_TRACING_WARNING_MAX_CALL_HISTORY: int
FREQUENT_TRACING_WARNING_THRESHOLD: int
FREQUENT_TRACING_WARNING_MAX_WARNING_PER_DETECTOR: int
ALLOW_DYNAMIC_VARIABLE_CREATION: bool

class _FrequentTracingDetector:
    def __init__(self) -> None: ...
    def called_with_tracing(self, function_name, omit_warning) -> None: ...
    def called_without_tracing(self) -> None: ...

class _FrequentTracingDetectorManager:
    def __init__(self) -> None: ...
    def called_without_tracing(self, key) -> None: ...
    def called_with_tracing(self, key, function_name, omit_warning) -> None: ...

class UnliftedInitializerVariable(resource_variable_ops.UninitializedVariable):
    def __init__(self, initial_value: Any | None = ..., trainable: Any | None = ..., caching_device: Any | None = ..., name: Any | None = ..., dtype: Any | None = ..., constraint: Any | None = ..., add_initializers_to: Any | None = ..., lifted_initializer_graph: Any | None = ..., synchronization: Any | None = ..., aggregation: Any | None = ..., shape: Any | None = ..., **unused_kwargs): ...

RUN_FUNCTIONS_EAGERLY: bool

def experimental_run_functions_eagerly(run_eagerly): ...
def run_functions_eagerly(run_eagerly) -> None: ...
def experimental_functions_run_eagerly(): ...
def functions_run_eagerly(): ...

class FunctionDeleter:
    func_graph: Any
    def __init__(self, func_graph) -> None: ...
    def __del__(self) -> None: ...

class OptionalXlaContext:
    xla_context: Any
    def __init__(self, is_compiled) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, t, value, traceback) -> None: ...

class Function(core.GenericFunction):
    def __init__(self, python_function, name, input_signature: Any | None = ..., autograph: bool = ..., jit_compile: Any | None = ..., experimental_implements: Any | None = ..., experimental_autograph_options: Any | None = ..., experimental_relax_shapes: bool = ..., experimental_follow_type_hints: Any | None = ...) -> None: ...
    def experimental_get_tracing_count(self): ...
    def __call__(self, *args, **kwds): ...
    def experimental_get_compiler_ir(self, *args, **kwargs): ...
    @property
    def python_function(self): ...
    @property
    def input_signature(self): ...
    @property
    def function_spec(self): ...
    def pretty_printed_concrete_signatures(self, verbose: bool = ...): ...
    def get_initialization_function(self, *args, **kwargs): ...
    def get_concrete_function(self, *args, **kwargs): ...
    def __get__(self, instance, owner): ...

def function(func: Any | None = ..., input_signature: Any | None = ..., autograph: bool = ..., jit_compile: Any | None = ..., experimental_implements: Any | None = ..., experimental_autograph_options: Any | None = ..., experimental_relax_shapes: bool = ..., experimental_compile: Any | None = ..., experimental_follow_type_hints: Any | None = ...) -> core.GenericFunction: ...
