import threading
from tensorflow.core.framework import function_pb2 as function_pb2
from tensorflow.core.protobuf import config_pb2 as config_pb2, rewriter_config_pb2 as rewriter_config_pb2
from tensorflow.python import pywrap_tfe as pywrap_tfe, tf2 as tf2
from tensorflow.python.client import pywrap_tf_session as pywrap_tf_session
from tensorflow.python.eager import executor as executor, monitoring as monitoring
from tensorflow.python.framework import c_api_util as c_api_util, tfrt_utils as tfrt_utils
from tensorflow.python.util import compat as compat, is_in_graph_mode as is_in_graph_mode, tf_contextlib as tf_contextlib
from tensorflow.python.util.deprecation import deprecated as deprecated
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any, NamedTuple

GRAPH_MODE: int
EAGER_MODE: int
default_execution_mode: Any
DEVICE_PLACEMENT_EXPLICIT: Any
DEVICE_PLACEMENT_WARN: Any
DEVICE_PLACEMENT_SILENT: Any
DEVICE_PLACEMENT_SILENT_FOR_INT32: Any
SYNC: int
ASYNC: int
is_tfrt_enabled: Any

def enable_run_eager_op_as_function() -> None: ...
def disable_run_eager_op_as_function() -> None: ...
def run_eager_op_as_function_enabled(): ...

class _EagerTensorCache:
    def __init__(self, max_items: int = ..., max_tensor_size: int = ...) -> None: ...
    def put(self, key, value) -> None: ...
    def get(self, key): ...
    def flush(self) -> None: ...

class FunctionCallOptions:
    def __init__(self, executor_type: Any | None = ..., config_proto: Any | None = ...) -> None: ...
    @property
    def executor_type(self): ...
    @executor_type.setter
    def executor_type(self, executor_type) -> None: ...
    @property
    def config_proto_serialized(self): ...
    @config_proto_serialized.setter
    def config_proto_serialized(self, config) -> None: ...

class _TensorCaches(threading.local):
    def __init__(self) -> None: ...
    @property
    def ones_rank_cache(self): ...
    @property
    def zeros_cache(self): ...

class ContextSwitch(NamedTuple):
    is_building_function: Any
    enter_context_fn: Any
    device_stack: Any

class _ContextSwitchStack(threading.local):
    stack: Any
    def __init__(self, eager) -> None: ...
    def push(self, is_building_function, enter_context_fn, device_stack) -> None: ...
    def pop(self) -> None: ...

class LogicalDevice: ...

class LogicalDeviceConfiguration:
    def __new__(cls, memory_limit: Any | None = ..., experimental_priority: Any | None = ...): ...

class PhysicalDevice: ...

class _AtomicCounter:
    def __init__(self) -> None: ...
    def increment_and_get(self): ...

class _TensorCacheDeleter:
    def __init__(self, context_id) -> None: ...
    def __del__(self) -> None: ...

class Context:
    def __init__(self, config: Any | None = ..., device_policy: Any | None = ..., execution_mode: Any | None = ..., server_def: Any | None = ...): ...
    def ensure_initialized(self) -> None: ...
    def get_server_def(self): ...
    def set_server_def(self, server_def, keep_alive_secs=...) -> None: ...
    def update_server_def(self, server_def, keep_alive_secs=...) -> None: ...
    def check_alive(self, worker_name): ...
    def sync_executors(self) -> None: ...
    def clear_executor_errors(self) -> None: ...
    def enable_coordination_service(self, service_type) -> None: ...
    @property
    def coordination_service(self): ...
    def set_config_key_value(self, key, value) -> None: ...
    def get_config_key_value(self, key): ...
    def delete_config_key_value(self, key) -> None: ...
    def report_error_to_cluster(self, error_code, error_message) -> None: ...
    def clear_kernel_cache(self) -> None: ...
    def enable_collective_ops(self, server_def) -> None: ...
    def configure_collective_ops(self, collective_leader: str = ..., scoped_allocator_enabled_ops=..., use_nccl_communication: bool = ..., device_filters: Any | None = ...) -> None: ...
    def abort_collective_ops(self, code, message) -> None: ...
    def check_collective_ops_peer_health(self, task, timeout_in_ms) -> None: ...
    def executing_eagerly(self): ...
    def ones_rank_cache(self): ...
    def zeros_cache(self): ...
    @property
    def scope_name(self): ...
    @scope_name.setter
    def scope_name(self, s) -> None: ...
    @property
    def device_name(self): ...
    @property
    def device_spec(self): ...
    def device(self, name): ...
    def devices(self): ...
    def host_address_space(self): ...
    @property
    def execution_mode(self): ...
    @execution_mode.setter
    def execution_mode(self, mode) -> None: ...
    def is_async(self): ...
    @property
    def executor(self): ...
    @executor.setter
    def executor(self, e) -> None: ...
    @property
    def config(self): ...
    @property
    def function_call_options(self): ...
    @function_call_options.setter
    def function_call_options(self, options) -> None: ...
    def num_gpus(self): ...
    def add_function(self, fn) -> None: ...
    def add_function_def(self, fdef) -> None: ...
    def get_function_def(self, name): ...
    def register_custom_device(self, device_capsule, device_name, device_info_capsule) -> None: ...
    def pack_eager_tensors(self, tensors): ...
    def list_function_names(self): ...
    def remove_function(self, name) -> None: ...
    def has_function(self, name): ...
    def add_op_callback(self, callback) -> None: ...
    def remove_op_callback(self, callback) -> None: ...
    @property
    def op_callbacks(self): ...
    @property
    def invoking_op_callbacks(self): ...
    @invoking_op_callbacks.setter
    def invoking_op_callbacks(self, value) -> None: ...
    def reinitialize_physical_devices(self) -> None: ...
    def list_physical_devices(self, device_type: Any | None = ...): ...
    def get_device_details(self, device): ...
    def list_logical_devices(self, device_type: Any | None = ...): ...
    def get_visible_devices(self, device_type: Any | None = ...): ...
    def set_visible_devices(self, devices, device_type: Any | None = ...) -> None: ...
    def get_memory_info(self, dev): ...
    def reset_memory_stats(self, dev) -> None: ...
    def get_memory_growth(self, dev): ...
    def set_memory_growth(self, dev, enable) -> None: ...
    def get_logical_device_configuration(self, dev): ...
    def set_logical_device_configuration(self, dev, virtual_devices) -> None: ...
    def set_logical_cpu_devices(self, num_cpus, prefix: str = ...) -> None: ...
    def get_compiler_ir(self, device_name, function_name, args, stage: str = ...): ...
    def enable_xla_devices(self) -> None: ...
    @property
    def enable_mlir_bridge(self): ...
    @property
    def enable_mlir_graph_optimization(self): ...
    @enable_mlir_bridge.setter
    def enable_mlir_bridge(self, enabled) -> None: ...
    @enable_mlir_graph_optimization.setter
    def enable_mlir_graph_optimization(self, enabled) -> None: ...
    @property
    def optimizer_jit(self): ...
    @optimizer_jit.setter
    def optimizer_jit(self, enabled) -> None: ...
    def get_optimizer_experimental_options(self): ...
    def set_optimizer_experimental_options(self, options) -> None: ...
    @property
    def intra_op_parallelism_threads(self): ...
    @intra_op_parallelism_threads.setter
    def intra_op_parallelism_threads(self, num_threads) -> None: ...
    @property
    def inter_op_parallelism_threads(self): ...
    @inter_op_parallelism_threads.setter
    def inter_op_parallelism_threads(self, num_threads) -> None: ...
    @property
    def soft_device_placement(self): ...
    @soft_device_placement.setter
    def soft_device_placement(self, enable) -> None: ...
    @property
    def log_device_placement(self): ...
    @log_device_placement.setter
    def log_device_placement(self, enable) -> None: ...
    @property
    def device_policy(self): ...
    @device_policy.setter
    def device_policy(self, policy) -> None: ...
    @property
    def use_tfrt(self): ...
    @use_tfrt.setter
    def use_tfrt(self, tfrt) -> None: ...
    @property
    def use_tfrt_distributed_runtime(self): ...
    @use_tfrt_distributed_runtime.setter
    def use_tfrt_distributed_runtime(self, enable) -> None: ...
    def enable_run_metadata(self) -> None: ...
    def disable_run_metadata(self) -> None: ...
    def enable_graph_collection(self) -> None: ...
    def disable_graph_collection(self) -> None: ...
    def export_run_metadata(self): ...
    @property
    def context_switches(self): ...

class _EagerDeviceContext:
    def __init__(self, ctx, device_name) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, *ex_info) -> None: ...

def context(): ...
def context_safe(): ...
def ensure_initialized() -> None: ...
def initialize_logical_devices() -> None: ...
def set_global_seed(seed) -> None: ...
def global_seed(): ...
def internal_operation_seed(): ...
def executing_eagerly(): ...
def executing_eagerly_v1(): ...
def in_eager_mode(): ...
def anonymous_name(): ...
def graph_mode(): ...
def eager_mode(): ...
def scope_name(): ...
def device(name): ...
def get_config(): ...
def get_device_name(): ...
def set_soft_device_placement(enabled) -> None: ...
def get_executor(): ...
def get_log_device_placement(): ...
def set_log_device_placement(enabled) -> None: ...
def device_policy(policy) -> None: ...
def set_execution_mode(mode) -> None: ...
def execution_mode(mode) -> None: ...
def executor_scope(e) -> None: ...
def function_executor_type(executor_type) -> None: ...
def is_async(): ...
def num_gpus(): ...
def enable_run_metadata() -> None: ...
def disable_run_metadata() -> None: ...
def enable_graph_collection() -> None: ...
def disable_graph_collection() -> None: ...
def export_run_metadata(): ...
def collect_graphs(optimized: bool = ...) -> None: ...
def get_server_def(): ...
def set_server_def(server_def) -> None: ...
def update_server_def(server_def) -> None: ...
def check_alive(worker_name): ...
def async_scope() -> None: ...
def async_wait() -> None: ...
def async_clear_error() -> None: ...
def add_function(fdef) -> None: ...
def remove_function(name) -> None: ...
def get_function_def(name): ...
def register_custom_device(device_capsule, device_name, device_info_capsule) -> None: ...
