import abc
from tensorflow.core.protobuf import config_pb2 as config_pb2
from tensorflow.python.client import session as session
from tensorflow.python.debug.lib import debug_utils as debug_utils
from tensorflow.python.framework import errors as errors, ops as ops
from tensorflow.python.platform import tf_logging as tf_logging
from tensorflow.python.training import monitored_session as monitored_session
from tensorflow.python.util import nest as nest
from tensorflow.python.util.compat import collections_abc as collections_abc
from typing import Any

class OnSessionInitRequest:
    session: Any
    def __init__(self, sess) -> None: ...

class OnSessionInitAction:
    PROCEED: str
    REMOTE_INSTR_LOOP: str

class OnSessionInitResponse:
    action: Any
    def __init__(self, action) -> None: ...

class OnRunStartRequest:
    fetches: Any
    feed_dict: Any
    run_options: Any
    run_metadata: Any
    run_call_count: Any
    is_callable_runner: Any
    def __init__(self, fetches, feed_dict, run_options, run_metadata, run_call_count, is_callable_runner: bool = ...) -> None: ...

class OnRunStartAction:
    DEBUG_RUN: str
    PROFILE_RUN: str
    NON_DEBUG_RUN: str

class OnRunStartResponse:
    action: Any
    debug_urls: Any
    debug_ops: Any
    node_name_regex_allowlist: Any
    op_type_regex_allowlist: Any
    tensor_dtype_regex_allowlist: Any
    tolerate_debug_op_creation_failures: Any
    def __init__(self, action, debug_urls, debug_ops: str = ..., node_name_regex_allowlist: Any | None = ..., op_type_regex_allowlist: Any | None = ..., tensor_dtype_regex_allowlist: Any | None = ..., tolerate_debug_op_creation_failures: bool = ...) -> None: ...

class OnRunEndRequest:
    performed_action: Any
    run_metadata: Any
    client_graph_def: Any
    tf_error: Any
    def __init__(self, performed_action, run_metadata: Any | None = ..., client_graph_def: Any | None = ..., tf_error: Any | None = ...) -> None: ...

class OnRunEndResponse:
    def __init__(self) -> None: ...

class BaseDebugWrapperSession(session.SessionInterface, metaclass=abc.ABCMeta):
    def __init__(self, sess, thread_name_filter: Any | None = ..., pass_through_operrors: bool = ...) -> None: ...
    @property
    def graph(self): ...
    @property
    def graph_def(self): ...
    @property
    def sess_str(self): ...
    @property
    def session(self): ...
    def run(self, fetches, feed_dict: Any | None = ..., options: Any | None = ..., run_metadata: Any | None = ..., callable_runner: Any | None = ..., callable_runner_args: Any | None = ..., callable_options: Any | None = ...): ...
    def run_step_fn(self, step_fn): ...
    def partial_run_setup(self, fetches, feeds: Any | None = ...) -> None: ...
    def partial_run(self, handle, fetches, feed_dict: Any | None = ...) -> None: ...
    def list_devices(self, *args, **kwargs): ...
    def reset(self, *args, **kwargs): ...
    def make_callable(self, fetches, feed_list: Any | None = ..., accept_options: bool = ...): ...
    @property
    def run_call_count(self): ...
    def increment_run_call_count(self) -> None: ...
    @abc.abstractmethod
    def on_session_init(self, request): ...
    @abc.abstractmethod
    def on_run_start(self, request): ...
    @abc.abstractmethod
    def on_run_end(self, request): ...
    def as_default(self): ...
    def __enter__(self): ...
    def __exit__(self, exec_type, exec_value, exec_tb) -> None: ...
    def __del__(self) -> None: ...
    def close(self) -> None: ...
    def should_stop(self): ...

class WatchOptions:
    debug_ops: Any
    node_name_regex_allowlist: Any
    op_type_regex_allowlist: Any
    tensor_dtype_regex_allowlist: Any
    tolerate_debug_op_creation_failures: Any
    def __init__(self, debug_ops: Any | None = ..., node_name_regex_allowlist: Any | None = ..., op_type_regex_allowlist: Any | None = ..., tensor_dtype_regex_allowlist: Any | None = ..., tolerate_debug_op_creation_failures: bool = ...) -> None: ...

class NonInteractiveDebugWrapperSession(BaseDebugWrapperSession, metaclass=abc.ABCMeta):
    def __init__(self, sess, watch_fn: Any | None = ..., thread_name_filter: Any | None = ..., pass_through_operrors: bool = ...) -> None: ...
    def on_session_init(self, request): ...
    @abc.abstractmethod
    def prepare_run_debug_urls(self, fetches, feed_dict): ...
    def on_run_start(self, request): ...
    def on_run_end(self, request): ...
