import abc
from tensorflow.python.data.ops import optional_ops as optional_ops
from tensorflow.python.data.util import nest as nest, structure as structure
from tensorflow.python.eager import context as context
from tensorflow.python.framework import composite_tensor as composite_tensor, dtypes as dtypes, errors as errors, ops as ops, tensor_shape as tensor_shape, tensor_spec as tensor_spec, type_spec as type_spec
from tensorflow.python.ops import gen_dataset_ops as gen_dataset_ops
from tensorflow.python.training.saver import BaseSaverBuilder as BaseSaverBuilder
from tensorflow.python.training.tracking import base as trackable
from tensorflow.python.util import deprecation as deprecation, lazy_loader as lazy_loader
from tensorflow.python.util.compat import collections_abc as collections_abc
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

GET_NEXT_CALL_WARNING_THRESHOLD: int
GET_NEXT_CALL_WARNING_MESSAGE: str
GET_NEXT_CALL_ERROR_THRESHOLD: int
GET_NEXT_CALL_ERROR_MESSAGE: str
GLOBAL_ITERATORS: str
autograph_ctx: Any

class Iterator(trackable.Trackable):
    def __init__(self, iterator_resource, initializer, output_types, output_shapes, output_classes) -> None: ...
    @staticmethod
    def from_structure(output_types, output_shapes: Any | None = ..., shared_name: Any | None = ..., output_classes: Any | None = ...): ...
    @staticmethod
    def from_string_handle(string_handle, output_types, output_shapes: Any | None = ..., output_classes: Any | None = ...): ...
    @property
    def initializer(self): ...
    def make_initializer(self, dataset, name: Any | None = ...): ...
    def get_next(self, name: Any | None = ...): ...
    def get_next_as_optional(self): ...
    def string_handle(self, name: Any | None = ...): ...
    @property
    def output_classes(self): ...
    @property
    def output_shapes(self): ...
    @property
    def output_types(self): ...
    @property
    def element_spec(self): ...

class IteratorResourceDeleter:
    def __init__(self, handle, deleter) -> None: ...
    def __del__(self) -> None: ...

class IteratorBase(collections_abc.Iterator, trackable.Trackable, composite_tensor.CompositeTensor, metaclass=abc.ABCMeta):
    @property
    @abc.abstractmethod
    def element_spec(self): ...
    @abc.abstractmethod
    def get_next(self): ...
    @abc.abstractmethod
    def get_next_as_optional(self): ...

class OwnedIterator(IteratorBase):
    def __init__(self, dataset: Any | None = ..., components: Any | None = ..., element_spec: Any | None = ...) -> None: ...
    def __iter__(self): ...
    def next(self): ...
    def __next__(self): ...
    @property
    def output_classes(self): ...
    @property
    def output_shapes(self): ...
    @property
    def output_types(self): ...
    @property
    def element_spec(self): ...
    def get_next(self): ...
    def get_next_as_optional(self): ...

class IteratorSpec(type_spec.TypeSpec):
    def __init__(self, element_spec) -> None: ...
    @property
    def value_type(self): ...
    @staticmethod
    def from_value(value): ...

class _IteratorSaveable(BaseSaverBuilder.SaveableObject):
    def __init__(self, iterator_resource, name, external_state_policy=...) -> None: ...
    def restore(self, restored_tensors, restored_shapes): ...

def get_next_as_optional(iterator): ...
