from tensorflow.core.protobuf import service_config_pb2 as service_config_pb2
from tensorflow.python.data.experimental.ops import data_service_ops as data_service_ops
from tensorflow.python.data.experimental.service import server_lib as server_lib
from tensorflow.python.data.kernel_tests import test_base as test_base
from tensorflow.python.data.ops import dataset_ops as dataset_ops
from tensorflow.python.framework import combinations as combinations
from tensorflow.python.platform import googletest as googletest
from typing import Any

TMP_WORK_DIR: str
NO_WORK_DIR: str
TEST_HEARTBEAT_INTERVAL_MS: int
TEST_DISPATCHER_TIMEOUT_MS: int
PROTOCOL: str
TRANSFER_PROTOCOL: Any

def all_cluster_configurations(): ...

class TestWorker:
    def __init__(self, dispatcher_address, shutdown_quiet_period_ms, data_transfer_protocol: Any | None = ..., worker_tags: Any | None = ...) -> None: ...
    def stop(self) -> None: ...
    def start(self) -> None: ...
    def restart(self, use_same_port: bool = ...) -> None: ...
    def join(self) -> None: ...
    def num_tasks(self): ...
    def worker_address(self): ...

class TestCluster:
    dispatcher: Any
    workers: Any
    def __init__(self, num_workers, dispatcher_port: int = ..., work_dir=..., fault_tolerant_mode: bool = ..., job_gc_check_interval_ms: Any | None = ..., job_gc_timeout_ms: Any | None = ..., worker_shutdown_quiet_period_ms: int = ..., start: bool = ..., data_transfer_protocol: Any | None = ...) -> None: ...
    def dispatcher_address(self): ...
    def add_worker(self, start: bool = ...) -> None: ...
    def start_dispatcher(self) -> None: ...
    def start_workers(self) -> None: ...
    def stop_dispatcher(self) -> None: ...
    def stop_workers(self) -> None: ...
    def restart_dispatcher(self) -> None: ...
    def num_registered_workers(self): ...
    def num_tasks_on_workers(self): ...
    def __del__(self) -> None: ...

class TestBase(test_base.DatasetTestBase):
    def register_dataset(self, dispatcher_address, dataset): ...
    def from_dataset_id(self, processing_mode, cluster, dataset_id, element_spec, job_name: Any | None = ...): ...
    def make_distributed_dataset(self, dataset, cluster, processing_mode: str = ..., job_name: Any | None = ..., consumer_index: Any | None = ..., num_consumers: Any | None = ..., max_outstanding_requests: Any | None = ..., compression: str = ..., target_workers: str = ...): ...
    def make_distributed_range_dataset(self, num_elements, cluster, processing_mode: str = ..., job_name: Any | None = ..., max_outstanding_requests: Any | None = ..., compression: str = ..., target_workers: str = ...): ...
    def make_coordinated_read_dataset(self, cluster, num_consumers): ...
    def checkCoordinatedReadGroups(self, results, num_consumers) -> None: ...
    def read(self, get_next, results, count) -> None: ...
