from tensorflow.compiler.tf2tensorrt._pywrap_py_utils import is_tensorrt_enabled as is_tensorrt_enabled
from tensorflow.core.framework import graph_pb2 as graph_pb2
from tensorflow.core.protobuf import config_pb2 as config_pb2, rewriter_config_pb2 as rewriter_config_pb2
from tensorflow.python.compiler.tensorrt import trt_convert as trt_convert
from tensorflow.python.eager import def_function as def_function
from tensorflow.python.framework import graph_io as graph_io, ops as ops, tensor_spec as tensor_spec, test_util as test_util
from tensorflow.python.ops import array_ops as array_ops, math_ops as math_ops
from tensorflow.python.profiler import trace as trace
from tensorflow.python.saved_model import builder as builder, load as load, loader as loader, save as save, signature_constants as signature_constants, signature_def_utils as signature_def_utils, tag_constants as tag_constants, utils as utils
from tensorflow.python.tools import saved_model_utils as saved_model_utils
from tensorflow.python.training.tracking import tracking as tracking
from tensorflow.python.util import nest as nest
from typing import Any, NamedTuple

class TfTrtIntegrationTestParams(NamedTuple):
    graph_fn: Any
    input_specs: Any
    output_specs: Any
    input_dims: Any
    expected_output_dims: Any

class RunParams(NamedTuple):
    convert_online: Any
    precision_mode: Any
    dynamic_engine: Any
    use_calibration: Any
    test_name: Any
    is_v2: Any
    dynamic_shape: Any
FP32: str
FP16: str
INT8: str
PRECISION_MODES: Any

def IsQuantizationMode(mode): ...
def IsQuantizationWithCalibration(params): ...
def IsQuantizationWithoutCalibration(params): ...

class GraphState:
    ORIGINAL: int
    CALIBRATE: int
    INFERENCE: int

class TfTrtIntegrationTestBase(test_util.TensorFlowTestCase):
    @property
    def trt_incompatible_op(self): ...
    @property
    def precision_modes(self): ...
    def __init__(self, methodName: str = ...) -> None: ...
    def setUp(self) -> None: ...
    def BuildParams(self, graph_fn, dtype, input_shapes, output_shapes): ...
    def BuildParamsWithMask(self, graph_fn, dtype, input_shapes, output_shapes, input_mask, output_mask, extra_inputs, extra_outputs): ...
    def DisableNonTrtOptimizers(self) -> None: ...
    def GetParams(self) -> None: ...
    def GetConversionParams(self, run_params): ...
    def GetMaxBatchSize(self, run_params): ...
    def ShouldRunTest(self, run_params): ...
    def ExpectedEnginesToBuild(self, run_params) -> None: ...
    def ExpectedMaxBatchSizes(self, run_params) -> None: ...
    def ExpectedAbsoluteTolerance(self, run_params): ...
    def ExpectedRelativeTolerance(self, run_params): ...
    def RunTest(self, run_params): ...
    def testIdempotence(self) -> None: ...
