from tensorflow.core.protobuf import config_pb2 as config_pb2, rewriter_config_pb2 as rewriter_config_pb2
from tensorflow.python.eager import context as context, monitoring as monitoring
from tensorflow.python.framework import device as device, error_interpolation as error_interpolation, errors as errors, ops as ops, sparse_tensor as sparse_tensor
from tensorflow.python.ops import session_ops as session_ops
from tensorflow.python.training.experimental import mixed_precision_global_state as mixed_precision_global_state
from tensorflow.python.util import compat as compat, nest as nest
from tensorflow.python.util.compat import collections_abc as collections_abc
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

class SessionInterface:
    @property
    def graph(self) -> None: ...
    @property
    def sess_str(self) -> None: ...
    def run(self, fetches, feed_dict: Any | None = ..., options: Any | None = ..., run_metadata: Any | None = ...) -> None: ...
    def partial_run_setup(self, fetches, feeds: Any | None = ...) -> None: ...
    def partial_run(self, handle, fetches, feed_dict: Any | None = ...) -> None: ...

def register_session_run_conversion_functions(tensor_type, fetch_function, feed_function: Any | None = ..., feed_function_for_partial_run: Any | None = ...) -> None: ...

class _FetchMapper:
    def unique_fetches(self) -> None: ...
    def build_results(self, values) -> None: ...
    @staticmethod
    def for_fetch(fetch): ...

class _ElementFetchMapper(_FetchMapper):
    def __init__(self, fetches, contraction_fn) -> None: ...
    def unique_fetches(self): ...
    def build_results(self, values): ...

class _ListFetchMapper(_FetchMapper):
    def __init__(self, fetches) -> None: ...
    def unique_fetches(self): ...
    def build_results(self, values): ...

class _DictFetchMapper(_FetchMapper):
    def __init__(self, fetches) -> None: ...
    def unique_fetches(self): ...
    def build_results(self, values): ...

class _AttrsFetchMapper(_FetchMapper):
    def __init__(self, fetches) -> None: ...
    def unique_fetches(self): ...
    def build_results(self, values): ...

class _FetchHandler:
    def __init__(self, graph, fetches, feeds, feed_handles: Any | None = ...) -> None: ...
    def fetches(self): ...
    def targets(self): ...
    def build_results(self, session, tensor_values): ...

class _DeviceAttributes:
    def __init__(self, name, device_type, memory_limit_bytes, incarnation) -> None: ...
    @property
    def name(self): ...
    @property
    def device_type(self): ...
    @property
    def memory_limit_bytes(self): ...
    @property
    def incarnation(self): ...

class BaseSession(SessionInterface):
    def __init__(self, target: str = ..., graph: Any | None = ..., config: Any | None = ...) -> None: ...
    def list_devices(self): ...
    def close(self) -> None: ...
    def __del__(self) -> None: ...
    @property
    def graph(self): ...
    @property
    def graph_def(self): ...
    @property
    def sess_str(self): ...
    def as_default(self): ...
    def run(self, fetches, feed_dict: Any | None = ..., options: Any | None = ..., run_metadata: Any | None = ...): ...
    def partial_run(self, handle, fetches, feed_dict: Any | None = ...): ...
    def partial_run_setup(self, fetches, feeds: Any | None = ...): ...
    def make_callable(self, fetches, feed_list: Any | None = ..., accept_options: bool = ...): ...
    class _Callable:
        def __init__(self, session, callable_options) -> None: ...
        def __call__(self, *args, **kwargs): ...
        def __del__(self) -> None: ...

class Session(BaseSession):
    def __init__(self, target: str = ..., graph: Any | None = ..., config: Any | None = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exec_type, exec_value, exec_tb) -> None: ...
    @staticmethod
    def reset(target, containers: Any | None = ..., config: Any | None = ...) -> None: ...

class InteractiveSession(BaseSession):
    def __init__(self, target: str = ..., graph: Any | None = ..., config: Any | None = ...) -> None: ...
    def close(self) -> None: ...
