import enum
import gast
from tensorflow.python.autograph.pyct import anno as anno, parser as parser, pretty_printer as pretty_printer, templates as templates
from typing import Any

class AnalysisLevel(enum.IntEnum):
    NONE: int
    ACTIVITY: int
    DEFINEDNESS: int
    LIVENESS: int

class Context:
    info: Any
    namer: Any
    current_origin: Any
    user: Any
    def __init__(self, info, namer, user_context) -> None: ...

class EntityInfo: ...

class _StateStack:
    def __init__(self, type_) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_value, traceback) -> None: ...
    def enter(self) -> None: ...
    def exit(self) -> None: ...
    @property
    def stack(self): ...
    @property
    def level(self): ...
    @property
    def value(self): ...
    def __iter__(self): ...
    def __getattr__(self, key): ...
    def __setattr__(self, key, value) -> None: ...

class _State:
    def __init__(self) -> None: ...
    def __getitem__(self, key): ...

class NodeStateTracker:
    ctx: Any
    state: Any
    def __init__(self, ctx) -> None: ...
    def debug_print(self, node): ...
    def debug_print_src(self, node): ...
    def visit_block(self, nodes, before_visit: Any | None = ..., after_visit: Any | None = ...): ...

class Base(NodeStateTracker, gast.NodeTransformer):
    def create_assignment(self, target, expression): ...
    def apply_to_single_assignments(self, targets, values, apply_fn) -> None: ...
    def visit(self, node): ...

class CodeGenerator(NodeStateTracker, gast.NodeVisitor):
    source_map: Any
    def __init__(self, ctx) -> None: ...
    def emit(self, code) -> None: ...
    @property
    def code_buffer(self): ...
    def visit(self, node): ...
