import statsmodels.tsa.base.tsa_model as tsbase
from statsmodels.iolib.summary import Summary as Summary
from statsmodels.iolib.table import SimpleTable as SimpleTable
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.sm_exceptions import HypothesisTestWarning as HypothesisTestWarning
from statsmodels.tsa.coint_tables import c_sja as c_sja, c_sjt as c_sjt
from statsmodels.tsa.tsatools import duplication_matrix as duplication_matrix, lagmat as lagmat, rename_trend as rename_trend, vec as vec
from statsmodels.tsa.vector_ar.hypothesis_test_results import CausalityTestResults as CausalityTestResults, WhitenessTestResults as WhitenessTestResults
from statsmodels.tsa.vector_ar.util import get_index as get_index, seasonal_dummies as seasonal_dummies
from statsmodels.tsa.vector_ar.var_model import LagOrderResults as LagOrderResults, VAR as VAR, forecast as forecast, forecast_interval as forecast_interval, ma_rep as ma_rep, orth_ma_rep as orth_ma_rep, test_normality as test_normality
from typing import Any

def select_order(data, maxlags, deterministic: str = ..., seasons: int = ..., exog: Any | None = ..., exog_coint: Any | None = ...): ...

class CointRankResults:
    rank: Any
    neqs: Any
    r_1: Any
    test_stats: Any
    crit_vals: Any
    method: Any
    signif: Any
    def __init__(self, rank, neqs, test_stats, crit_vals, method: str = ..., signif: float = ...) -> None: ...
    def summary(self): ...

def select_coint_rank(endog, det_order, k_ar_diff, method: str = ..., signif: float = ...): ...
def coint_johansen(endog, det_order, k_ar_diff): ...

class JohansenTestResult:
    def __init__(self, rkt, r0t, eig, evec, lr1, lr2, cvt, cvm, ind) -> None: ...
    @property
    def rkt(self): ...
    @property
    def r0t(self): ...
    @property
    def eig(self): ...
    @property
    def evec(self): ...
    @property
    def trace_stat(self): ...
    @property
    def lr1(self): ...
    @property
    def max_eig_stat(self): ...
    @property
    def lr2(self): ...
    @property
    def trace_stat_crit_vals(self): ...
    @property
    def cvt(self): ...
    @property
    def cvm(self): ...
    @property
    def max_eig_stat_crit_vals(self): ...
    @property
    def ind(self): ...
    @property
    def meth(self): ...

class VECM(tsbase.TimeSeriesModel):
    y: Any
    exog_coint: Any
    neqs: Any
    k_ar: Any
    k_ar_diff: Any
    coint_rank: Any
    deterministic: Any
    seasons: Any
    first_season: Any
    load_coef_repr: str
    def __init__(self, endog, exog: Any | None = ..., exog_coint: Any | None = ..., dates: Any | None = ..., freq: Any | None = ..., missing: str = ..., k_ar_diff: int = ..., coint_rank: int = ..., deterministic: str = ..., seasons: int = ..., first_season: int = ...) -> None: ...
    def fit(self, method: str = ...): ...

class VECMResults:
    model: Any
    y_all: Any
    exog: Any
    exog_coint: Any
    names: Any
    dates: Any
    neqs: Any
    k_ar: Any
    deterministic: Any
    seasons: Any
    first_season: Any
    coint_rank: Any
    alpha: Any
    const_coint: Any
    lin_trend_coint: Any
    exog_coint_coefs: Any
    sigma_u: Any
    nobs: Any
    def __init__(self, endog, exog, exog_coint, k_ar, coint_rank, alpha, beta, gamma, sigma_u, deterministic: str = ..., seasons: int = ..., first_season: int = ..., delta_y_1_T: Any | None = ..., y_lag1: Any | None = ..., delta_x: Any | None = ..., model: Any | None = ..., names: Any | None = ..., dates: Any | None = ...) -> None: ...
    def llf(self): ...
    def cov_params_default(self): ...
    def cov_params_wo_det(self): ...
    def stderr_params(self): ...
    def stderr_coint(self): ...
    def stderr_alpha(self): ...
    def stderr_beta(self): ...
    def stderr_det_coef_coint(self): ...
    def stderr_gamma(self): ...
    def stderr_det_coef(self): ...
    def tvalues_alpha(self): ...
    def tvalues_beta(self): ...
    def tvalues_det_coef_coint(self): ...
    def tvalues_gamma(self): ...
    def tvalues_det_coef(self): ...
    def pvalues_alpha(self): ...
    def pvalues_beta(self): ...
    def pvalues_det_coef_coint(self): ...
    def pvalues_gamma(self): ...
    def pvalues_det_coef(self): ...
    def conf_int_alpha(self, alpha: float = ...): ...
    def conf_int_beta(self, alpha: float = ...): ...
    def conf_int_det_coef_coint(self, alpha: float = ...): ...
    def conf_int_gamma(self, alpha: float = ...): ...
    def conf_int_det_coef(self, alpha: float = ...): ...
    def var_rep(self): ...
    def cov_var_repr(self): ...
    def ma_rep(self, maxn: int = ...): ...
    def orth_ma_rep(self, maxn: int = ..., P: Any | None = ...): ...
    def predict(self, steps: int = ..., alpha: Any | None = ..., exog_fc: Any | None = ..., exog_coint_fc: Any | None = ...): ...
    def plot_forecast(self, steps, alpha: float = ..., plot_conf_int: bool = ..., n_last_obs: Any | None = ...) -> None: ...
    def test_granger_causality(self, caused, causing: Any | None = ..., signif: float = ...): ...
    def test_inst_causality(self, causing, signif: float = ...): ...
    def irf(self, periods: int = ...): ...
    def fittedvalues(self): ...
    def resid(self): ...
    def test_normality(self, signif: float = ...): ...
    def test_whiteness(self, nlags: int = ..., signif: float = ..., adjusted: bool = ...): ...
    def plot_data(self, with_presample: bool = ...) -> None: ...
    def summary(self, alpha: float = ...): ...
