import statsmodels.base.wrapper as wrap
from statsmodels.compat.python import lrange as lrange
from statsmodels.iolib.table import SimpleTable as SimpleTable
from statsmodels.tools.decorators import cache_readonly as cache_readonly, deprecated_alias as deprecated_alias
from statsmodels.tools.linalg import logdet_symm as logdet_symm
from statsmodels.tools.sm_exceptions import OutputWarning as OutputWarning
from statsmodels.tools.validation import array_like as array_like
from statsmodels.tsa.base.tsa_model import TimeSeriesModel as TimeSeriesModel, TimeSeriesResultsWrapper as TimeSeriesResultsWrapper
from statsmodels.tsa.tsatools import duplication_matrix as duplication_matrix, unvec as unvec, vec as vec
from statsmodels.tsa.vector_ar import output as output, plotting as plotting, util as util
from statsmodels.tsa.vector_ar.hypothesis_test_results import CausalityTestResults as CausalityTestResults, NormalityTestResults as NormalityTestResults, WhitenessTestResults as WhitenessTestResults
from statsmodels.tsa.vector_ar.irf import IRAnalysis as IRAnalysis
from statsmodels.tsa.vector_ar.output import VARSummary as VARSummary
from typing import Any

def ma_rep(coefs, maxn: int = ...): ...
def is_stable(coefs, verbose: bool = ...): ...
def var_acf(coefs, sig_u, nlags: Any | None = ...): ...
def forecast_cov(ma_coefs, sigma_u, steps): ...
mse = forecast_cov

def forecast(y, coefs, trend_coefs, steps, exog: Any | None = ...): ...
def forecast_interval(y, coefs, trend_coefs, sig_u, steps: int = ..., alpha: float = ..., exog: int = ...): ...
def var_loglike(resid, omega, nobs): ...
def orth_ma_rep(results, maxn: int = ..., P: Any | None = ...): ...
def test_normality(results, signif: float = ...): ...

class LagOrderResults:
    title: Any
    ics: Any
    selected_orders: Any
    vecm: Any
    aic: Any
    bic: Any
    hqic: Any
    fpe: Any
    def __init__(self, ics, selected_orders, vecm: bool = ...) -> None: ...
    def summary(self): ...

class VAR(TimeSeriesModel):
    y: Any
    neqs: Any
    n_totobs: Any
    def __init__(self, endog, exog: Any | None = ..., dates: Any | None = ..., freq: Any | None = ..., missing: str = ...) -> None: ...
    def predict(self, params, start: Any | None = ..., end: Any | None = ..., lags: int = ..., trend: str = ...): ...
    exog_names: Any
    nobs: Any
    def fit(self, maxlags: Union[int, None] = ..., method: str = ..., ic: Any | None = ..., trend: str = ..., verbose: bool = ...): ...
    def select_order(self, maxlags: Any | None = ..., trend: str = ...): ...
    @classmethod
    def from_formula(cls, formula, data, subset: Any | None = ..., drop_cols: Any | None = ..., *args, **kwargs) -> None: ...

class VARProcess:
    k_ar: Any
    neqs: Any
    coefs: Any
    coefs_exog: Any
    sigma_u: Any
    names: Any
    k_exog_user: Any
    k_trend: Any
    k_exog: Any
    intercept: Any
    def __init__(self, coefs, coefs_exog, sigma_u, names: Any | None = ..., _params_info: Any | None = ...) -> None: ...
    def get_eq_index(self, name): ...
    def is_stable(self, verbose: bool = ...): ...
    def simulate_var(self, steps: Any | None = ..., offset: Any | None = ..., seed: Any | None = ...): ...
    def plotsim(self, steps: Any | None = ..., offset: Any | None = ..., seed: Any | None = ...): ...
    def intercept_longrun(self): ...
    def mean(self): ...
    def ma_rep(self, maxn: int = ...): ...
    def orth_ma_rep(self, maxn: int = ..., P: Any | None = ...): ...
    def long_run_effects(self): ...
    def acf(self, nlags: Any | None = ...): ...
    def acorr(self, nlags: Any | None = ...): ...
    def plot_acorr(self, nlags: int = ..., linewidth: int = ...): ...
    def forecast(self, y, steps, exog_future: Any | None = ...): ...
    def mse(self, steps): ...
    forecast_cov: Any
    def forecast_interval(self, y, steps, alpha: float = ..., exog_future: Any | None = ...): ...
    def to_vecm(self): ...

class VARResults(VARProcess):
    model: Any
    endog: Any
    endog_lagged: Any
    dates: Any
    nobs: Any
    trend: Any
    exog_names: Any
    params: Any
    exog: Any
    coefs_exog: Any
    k_exog: Any
    k_exog_user: Any
    def __init__(self, endog, endog_lagged, params, sigma_u, lag_order, model: Any | None = ..., trend: str = ..., names: Any | None = ..., dates: Any | None = ..., exog: Any | None = ...) -> None: ...
    def plot(self): ...
    @property
    def df_model(self): ...
    @property
    def df_resid(self): ...
    def fittedvalues(self): ...
    def resid(self): ...
    def sample_acov(self, nlags: int = ...): ...
    def sample_acorr(self, nlags: int = ...): ...
    def plot_sample_acorr(self, nlags: int = ..., linewidth: int = ...): ...
    def resid_acov(self, nlags: int = ...): ...
    def resid_acorr(self, nlags: int = ...): ...
    def resid_corr(self): ...
    def sigma_u_mle(self): ...
    def cov_params(self): ...
    def cov_ybar(self): ...
    def llf(self): ...
    def stderr(self): ...
    bse: Any
    def stderr_endog_lagged(self): ...
    def stderr_dt(self): ...
    def tvalues(self): ...
    def tvalues_endog_lagged(self): ...
    def tvalues_dt(self): ...
    def pvalues(self): ...
    def pvalues_endog_lagged(self): ...
    def pvalues_dt(self): ...
    def plot_forecast(self, steps, alpha: float = ..., plot_stderr: bool = ...): ...
    def forecast_cov(self, steps: int = ..., method: str = ...): ...
    def irf_errband_mc(self, orth: bool = ..., repl: int = ..., steps: int = ..., signif: float = ..., seed: Any | None = ..., burn: int = ..., cum: bool = ...): ...
    def irf_resim(self, orth: bool = ..., repl: int = ..., steps: int = ..., seed: Any | None = ..., burn: int = ..., cum: bool = ...): ...
    def summary(self): ...
    def irf(self, periods: int = ..., var_decomp: Any | None = ..., var_order: Any | None = ...): ...
    def fevd(self, periods: int = ..., var_decomp: Any | None = ...): ...
    def reorder(self, order): ...
    def test_causality(self, caused, causing: Any | None = ..., kind: str = ..., signif: float = ...): ...
    def test_inst_causality(self, causing, signif: float = ...): ...
    def test_whiteness(self, nlags: int = ..., signif: float = ..., adjusted: bool = ...): ...
    def plot_acorr(self, nlags: int = ..., resid: bool = ..., linewidth: int = ...): ...
    def test_normality(self, signif: float = ...): ...
    def detomega(self): ...
    def info_criteria(self): ...
    @property
    def aic(self): ...
    @property
    def fpe(self): ...
    @property
    def hqic(self): ...
    @property
    def bic(self): ...
    def roots(self): ...

class VARResultsWrapper(wrap.ResultsWrapper): ...

class FEVD:
    periods: Any
    model: Any
    neqs: Any
    names: Any
    irfobj: Any
    orth_irfs: Any
    decomp: Any
    def __init__(self, model, P: Any | None = ..., periods: Any | None = ...) -> None: ...
    def summary(self) -> None: ...
    def cov(self) -> None: ...
    def plot(self, periods: Any | None = ..., figsize=..., **plot_kwds): ...
