import numpy as np
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from typing import Any

mat = np.array

class BaseIRAnalysis:
    model: Any
    periods: Any
    order: Any
    P: Any
    svar: Any
    irfs: Any
    svar_irfs: Any
    orth_irfs: Any
    cum_effects: Any
    svar_cum_effects: Any
    orth_cum_effects: Any
    lr_effects: Any
    svar_lr_effects: Any
    orth_lr_effects: Any
    def __init__(self, model, P: Any | None = ..., periods: int = ..., order: Any | None = ..., svar: bool = ..., vecm: bool = ...) -> None: ...
    def cov(self, *args, **kwargs) -> None: ...
    def cum_effect_cov(self, *args, **kwargs) -> None: ...
    def plot(self, orth: bool = ..., *, impulse: Any | None = ..., response: Any | None = ..., signif: float = ..., plot_params: Any | None = ..., figsize=..., subplot_params: Any | None = ..., plot_stderr: bool = ..., stderr_type: str = ..., repl: int = ..., seed: Any | None = ..., component: Any | None = ...): ...
    def plot_cum_effects(self, orth: bool = ..., *, impulse: Any | None = ..., response: Any | None = ..., signif: float = ..., plot_params: Any | None = ..., figsize=..., subplot_params: Any | None = ..., plot_stderr: bool = ..., stderr_type: str = ..., repl: int = ..., seed: Any | None = ...): ...

class IRAnalysis(BaseIRAnalysis):
    cov_a: Any
    cov_sig: Any
    def __init__(self, model, P: Any | None = ..., periods: int = ..., order: Any | None = ..., svar: bool = ..., vecm: bool = ...) -> None: ...
    def cov(self, orth: bool = ...): ...
    def errband_mc(self, orth: bool = ..., svar: bool = ..., repl: int = ..., signif: float = ..., seed: Any | None = ..., burn: int = ...): ...
    def err_band_sz1(self, orth: bool = ..., svar: bool = ..., repl: int = ..., signif: float = ..., seed: Any | None = ..., burn: int = ..., component: Any | None = ...): ...
    def err_band_sz2(self, orth: bool = ..., svar: bool = ..., repl: int = ..., signif: float = ..., seed: Any | None = ..., burn: int = ..., component: Any | None = ...): ...
    def err_band_sz3(self, orth: bool = ..., svar: bool = ..., repl: int = ..., signif: float = ..., seed: Any | None = ..., burn: int = ..., component: Any | None = ...): ...
    def G(self): ...
    def cum_effect_cov(self, orth: bool = ...): ...
    def cum_errband_mc(self, orth: bool = ..., repl: int = ..., signif: float = ..., seed: Any | None = ..., burn: int = ...): ...
    def lr_effect_cov(self, orth: bool = ...): ...
    def stderr(self, orth: bool = ...): ...
    def cum_effect_stderr(self, orth: bool = ...): ...
    def lr_effect_stderr(self, orth: bool = ...): ...
    def H(self): ...
    def fevd_table(self) -> None: ...
