import statsmodels.tsa.base.prediction as pred
import statsmodels.tsa.base.tsa_model as tsbase
import statsmodels.base.wrapper as wrap
from .initialization import Initialization as Initialization
from .kalman_filter import INVERT_UNIVARIATE as INVERT_UNIVARIATE, MEMORY_CONSERVE as MEMORY_CONSERVE, SOLVE_LU as SOLVE_LU
from .kalman_smoother import SmootherResults as SmootherResults
from .news import NewsResults as NewsResults
from .simulation_smoother import SimulationSmoother as SimulationSmoother
from .tools import concat as concat, prepare_exog as prepare_exog
from statsmodels.base.data import PandasData as PandasData
from statsmodels.compat.pandas import is_int_index as is_int_index
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.eval_measures import aic as aic, aicc as aicc, bic as bic, hqic as hqic
from statsmodels.tools.numdiff import approx_fprime as approx_fprime, approx_fprime_cs as approx_fprime_cs, approx_hess_cs as approx_hess_cs
from statsmodels.tools.sm_exceptions import PrecisionWarning as PrecisionWarning, ValueWarning as ValueWarning
from statsmodels.tools.tools import Bunch as Bunch, pinv_extended as pinv_extended
from typing import Any

class MLEModel(tsbase.TimeSeriesModel):
    nobs: Any
    k_states: Any
    def __init__(self, endog, k_states, exog: Any | None = ..., dates: Any | None = ..., freq: Any | None = ..., **kwargs) -> None: ...
    def prepare_data(self): ...
    ssm: Any
    k_endog: Any
    def initialize_statespace(self, **kwargs) -> None: ...
    def __setitem__(self, key, value): ...
    def __getitem__(self, key): ...
    def clone(self, endog, exog: Any | None = ..., **kwargs) -> None: ...
    def set_filter_method(self, filter_method: Any | None = ..., **kwargs) -> None: ...
    def set_inversion_method(self, inversion_method: Any | None = ..., **kwargs) -> None: ...
    def set_stability_method(self, stability_method: Any | None = ..., **kwargs) -> None: ...
    def set_conserve_memory(self, conserve_memory: Any | None = ..., **kwargs) -> None: ...
    def set_smoother_output(self, smoother_output: Any | None = ..., **kwargs) -> None: ...
    def initialize_known(self, initial_state, initial_state_cov) -> None: ...
    def initialize_approximate_diffuse(self, variance: Any | None = ...) -> None: ...
    def initialize_stationary(self) -> None: ...
    @property
    def initialization(self): ...
    @initialization.setter
    def initialization(self, value) -> None: ...
    @property
    def initial_variance(self): ...
    @initial_variance.setter
    def initial_variance(self, value) -> None: ...
    @property
    def loglikelihood_burn(self): ...
    @loglikelihood_burn.setter
    def loglikelihood_burn(self, value) -> None: ...
    @property
    def tolerance(self): ...
    @tolerance.setter
    def tolerance(self, value) -> None: ...
    def fix_params(self, params) -> None: ...
    def fit(self, start_params: Any | None = ..., transformed: bool = ..., includes_fixed: bool = ..., cov_type: Any | None = ..., cov_kwds: Any | None = ..., method: str = ..., maxiter: int = ..., full_output: int = ..., disp: int = ..., callback: Any | None = ..., return_params: bool = ..., optim_score: Any | None = ..., optim_complex_step: Any | None = ..., optim_hessian: Any | None = ..., flags: Any | None = ..., low_memory: bool = ..., **kwargs): ...
    def fit_constrained(self, constraints, start_params: Any | None = ..., **fit_kwds): ...
    def filter(self, params, transformed: bool = ..., includes_fixed: bool = ..., complex_step: bool = ..., cov_type: Any | None = ..., cov_kwds: Any | None = ..., return_ssm: bool = ..., results_class: Any | None = ..., results_wrapper_class: Any | None = ..., low_memory: bool = ..., **kwargs): ...
    def smooth(self, params, transformed: bool = ..., includes_fixed: bool = ..., complex_step: bool = ..., cov_type: Any | None = ..., cov_kwds: Any | None = ..., return_ssm: bool = ..., results_class: Any | None = ..., results_wrapper_class: Any | None = ..., **kwargs): ...
    def loglike(self, params, *args, **kwargs): ...
    def loglikeobs(self, params, transformed: bool = ..., includes_fixed: bool = ..., complex_step: bool = ..., **kwargs): ...
    def simulation_smoother(self, simulation_output: Any | None = ..., **kwargs): ...
    def observed_information_matrix(self, params, transformed: bool = ..., includes_fixed: bool = ..., approx_complex_step: Any | None = ..., approx_centered: bool = ..., **kwargs): ...
    def opg_information_matrix(self, params, transformed: bool = ..., includes_fixed: bool = ..., approx_complex_step: Any | None = ..., **kwargs): ...
    def score(self, params, *args, **kwargs): ...
    def score_obs(self, params, method: str = ..., transformed: bool = ..., includes_fixed: bool = ..., approx_complex_step: Any | None = ..., approx_centered: bool = ..., **kwargs): ...
    def hessian(self, params, *args, **kwargs): ...
    @property
    def start_params(self): ...
    @property
    def param_names(self): ...
    @property
    def state_names(self): ...
    def transform_jacobian(self, unconstrained, approx_centered: bool = ...): ...
    def transform_params(self, unconstrained): ...
    def untransform_params(self, constrained): ...
    def handle_params(self, params, transformed: bool = ..., includes_fixed: bool = ..., return_jacobian: bool = ...): ...
    def update(self, params, transformed: bool = ..., includes_fixed: bool = ..., complex_step: bool = ...): ...
    def simulate(self, params, nsimulations, measurement_shocks: Any | None = ..., state_shocks: Any | None = ..., initial_state: Any | None = ..., anchor: Any | None = ..., repetitions: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., transformed: bool = ..., includes_fixed: bool = ..., **kwargs): ...
    def impulse_responses(self, params, steps: int = ..., impulse: int = ..., orthogonalized: bool = ..., cumulative: bool = ..., anchor: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., transformed: bool = ..., includes_fixed: bool = ..., **kwargs): ...
    @classmethod
    def from_formula(cls, formula, data, subset: Any | None = ...) -> None: ...

class MLEResults(tsbase.TimeSeriesModelResults):
    data: Any
    fixed_params: Any
    param_names: Any
    filter_results: Any
    smoother_results: Any
    nobs: Any
    nobs_diffuse: Any
    nobs_effective: Any
    k_diffuse_states: Any
    df_model: Any
    df_resid: Any
    cov_kwds: Any
    cov_type: Any
    cov_params_default: Any
    forecasts: Any
    forecasts_error: Any
    forecasts_error_cov: Any
    predicted_state: Any
    predicted_state_cov: Any
    filtered_state: Any
    filtered_state_cov: Any
    standardized_forecasts_error: Any
    def __init__(self, model, params, results, cov_type: Any | None = ..., cov_kwds: Any | None = ..., **kwargs) -> None: ...
    def aic(self): ...
    def aicc(self): ...
    def bic(self): ...
    def cov_params_approx(self): ...
    def cov_params_oim(self): ...
    def cov_params_opg(self): ...
    def cov_params_robust(self): ...
    def cov_params_robust_oim(self): ...
    def cov_params_robust_approx(self): ...
    def info_criteria(self, criteria, method: str = ...): ...
    def fittedvalues(self): ...
    def hqic(self): ...
    def llf_obs(self): ...
    def llf(self): ...
    def loglikelihood_burn(self): ...
    def mae(self): ...
    def mse(self): ...
    def pvalues(self): ...
    def resid(self): ...
    @property
    def states(self): ...
    def sse(self): ...
    def zvalues(self): ...
    def test_normality(self, method): ...
    def test_heteroskedasticity(self, method, alternative: str = ..., use_f: bool = ...): ...
    def test_serial_correlation(self, method, df_adjust: bool = ..., lags: Any | None = ...): ...
    def get_prediction(self, start: Any | None = ..., end: Any | None = ..., dynamic: bool = ..., index: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., **kwargs): ...
    def get_forecast(self, steps: int = ..., **kwargs): ...
    def predict(self, start: Any | None = ..., end: Any | None = ..., dynamic: bool = ..., **kwargs): ...
    def forecast(self, steps: int = ..., **kwargs): ...
    def simulate(self, nsimulations, measurement_shocks: Any | None = ..., state_shocks: Any | None = ..., initial_state: Any | None = ..., anchor: Any | None = ..., repetitions: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., **kwargs): ...
    def impulse_responses(self, steps: int = ..., impulse: int = ..., orthogonalized: bool = ..., cumulative: bool = ..., **kwargs): ...
    def news(self, comparison, impact_date: Any | None = ..., impacted_variable: Any | None = ..., start: Any | None = ..., end: Any | None = ..., periods: Any | None = ..., exog: Any | None = ..., comparison_type: Any | None = ..., return_raw: bool = ..., tolerance: float = ..., **kwargs): ...
    def append(self, endog, exog: Any | None = ..., refit: bool = ..., fit_kwargs: Any | None = ..., copy_initialization: bool = ..., **kwargs): ...
    def extend(self, endog, exog: Any | None = ..., fit_kwargs: Any | None = ..., **kwargs): ...
    def apply(self, endog, exog: Any | None = ..., refit: bool = ..., fit_kwargs: Any | None = ..., copy_initialization: bool = ..., **kwargs): ...
    def plot_diagnostics(self, variable: int = ..., lags: int = ..., fig: Any | None = ..., figsize: Any | None = ..., truncate_endog_names: int = ..., auto_ylims: bool = ..., bartlett_confint: bool = ..., acf_kwargs: Any | None = ...): ...
    def summary(self, alpha: float = ..., start: Any | None = ..., title: Any | None = ..., model_name: Any | None = ..., display_params: bool = ..., display_diagnostics: bool = ..., truncate_endog_names: Any | None = ..., display_max_endog: Any | None = ..., extra_top_left: Any | None = ..., extra_top_right: Any | None = ...): ...

class MLEResultsWrapper(wrap.ResultsWrapper): ...

class PredictionResults(pred.PredictionResults):
    model: Any
    prediction_results: Any
    def __init__(self, model, prediction_results, row_labels: Any | None = ...) -> None: ...
    @property
    def se_mean(self): ...
    def conf_int(self, method: str = ..., alpha: float = ..., **kwds): ...
    def summary_frame(self, endog: int = ..., alpha: float = ...): ...

class PredictionResultsWrapper(wrap.ResultsWrapper): ...
