from statsmodels.base.data import PandasData as PandasData
from statsmodels.genmod.generalized_linear_model import GLM as GLM
from statsmodels.iolib.summary import Summary as Summary
from statsmodels.iolib.table import SimpleTable as SimpleTable
from statsmodels.iolib.tableformatting import fmt_params as fmt_params
from statsmodels.multivariate.pca import PCA as PCA
from statsmodels.regression.linear_model import OLS as OLS
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.tools import Bunch as Bunch
from statsmodels.tools.validation import int_like as int_like, string_like as string_like
from statsmodels.tsa.statespace import initialization as initialization, mlemodel as mlemodel
from statsmodels.tsa.statespace._quarterly_ar1 import QuarterlyAR1 as QuarterlyAR1
from statsmodels.tsa.statespace.kalman_smoother import SMOOTHER_STATE as SMOOTHER_STATE, SMOOTHER_STATE_AUTOCOV as SMOOTHER_STATE_AUTOCOV, SMOOTHER_STATE_COV as SMOOTHER_STATE_COV
from statsmodels.tsa.statespace.sarimax import SARIMAX as SARIMAX
from statsmodels.tsa.statespace.tools import companion_matrix as companion_matrix, constrain_stationary_multivariate as constrain_stationary_multivariate, constrain_stationary_univariate as constrain_stationary_univariate, is_invertible as is_invertible, unconstrain_stationary_multivariate as unconstrain_stationary_multivariate, unconstrain_stationary_univariate as unconstrain_stationary_univariate
from statsmodels.tsa.tsatools import lagmat as lagmat
from statsmodels.tsa.vector_ar.var_model import VAR as VAR
from typing import Any

class FactorBlock(dict):
    factor_names: Any
    k_factors: Any
    factor_order: Any
    endog_factor_map: Any
    state_offset: Any
    k_endog_Q: Any
    k_states: Any
    def __init__(self, factor_names, factor_order, endog_factor_map, state_offset, k_endog_Q) -> None: ...
    @property
    def factors_ix(self): ...
    @property
    def factors(self): ...
    @property
    def factors_ar(self): ...
    @property
    def factors_L1(self): ...
    @property
    def factors_L1_5(self): ...

class DynamicFactorMQStates(dict):
    k_endog_M: Any
    k_endog_Q: Any
    k_endog: Any
    idiosyncratic_ar1: Any
    factors: Any
    factor_orders: Any
    factor_multiplicities: Any
    endog_factor_map: Any
    k_factors: Any
    loading_counts: Any
    block_loading_counts: Any
    factor_block_orders: Any
    factor_names: Any
    max_factor_order: Any
    k_states_factors: int
    k_posdef_factors: int
    factor_blocks: Any
    k_states_idio_M: Any
    k_states_idio_Q: Any
    k_states_idio: Any
    k_posdef_idio_M: Any
    k_posdef_idio_Q: Any
    k_posdef_idio: Any
    k_states: Any
    k_posdef: Any
    def __init__(self, k_endog_M, k_endog_Q, endog_names, factors, factor_orders, factor_multiplicities, idiosyncratic_ar1) -> None: ...
    @property
    def factors_L1(self): ...
    @property
    def factors_L1_5_ix(self): ...
    @property
    def idio_ar_L1(self): ...
    @property
    def idio_ar_M(self): ...
    @property
    def idio_ar_Q(self): ...
    @property
    def idio_ar_Q_ix(self): ...
    @property
    def endog_factor_iloc(self): ...
    def __getitem__(self, key): ...

class DynamicFactorMQ(mlemodel.MLEModel):
    k_endog_M: Any
    k_endog_Q: Any
    factors: Any
    factor_orders: Any
    factor_multiplicities: Any
    endog_factor_map: Any
    factor_block_orders: Any
    factor_names: Any
    k_factors: Any
    k_factor_blocks: Any
    max_factor_order: Any
    idiosyncratic_ar1: Any
    init_t0: Any
    obs_cov_diag: Any
    standardize: Any
    params: Any
    k_params: Any
    def __init__(self, endog, k_endog_monthly: Any | None = ..., factors: int = ..., factor_orders: int = ..., factor_multiplicities: Any | None = ..., idiosyncratic_ar1: bool = ..., standardize: bool = ..., endog_quarterly: Any | None = ..., init_t0: bool = ..., obs_cov_diag: bool = ..., **kwargs) -> None: ...
    @classmethod
    def construct_endog(cls, endog_monthly, endog_quarterly): ...
    def clone(self, endog, k_endog_monthly: Any | None = ..., endog_quarterly: Any | None = ..., retain_standardization: bool = ..., **kwargs): ...
    model: Any
    def summary(self, truncate_endog_names: Any | None = ...): ...
    @property
    def state_names(self): ...
    @property
    def param_names(self): ...
    @property
    def start_params(self): ...
    def transform_params(self, unconstrained): ...
    def untransform_params(self, constrained): ...
    def update(self, params, **kwargs) -> None: ...
    @property
    def loglike_constant(self): ...
    def loading_constraints(self, i): ...
    def fit(self, start_params: Any | None = ..., transformed: bool = ..., includes_fixed: bool = ..., cov_type: str = ..., cov_kwds: Any | None = ..., method: str = ..., maxiter: int = ..., tolerance: float = ..., em_initialization: bool = ..., mstep_method: Any | None = ..., full_output: int = ..., disp: bool = ..., callback: Any | None = ..., return_params: bool = ..., optim_score: Any | None = ..., optim_complex_step: Any | None = ..., optim_hessian: Any | None = ..., flags: Any | None = ..., low_memory: bool = ..., llf_decrease_action: str = ..., llf_decrease_tolerance: float = ..., **kwargs): ...
    def fit_em(self, start_params: Any | None = ..., transformed: bool = ..., cov_type: str = ..., cov_kwds: Any | None = ..., maxiter: int = ..., tolerance: float = ..., disp: bool = ..., em_initialization: bool = ..., mstep_method: Any | None = ..., full_output: bool = ..., return_params: bool = ..., low_memory: bool = ..., llf_decrease_action: str = ..., llf_decrease_tolerance: float = ...): ...
    def smooth(self, params, transformed: bool = ..., includes_fixed: bool = ..., complex_step: bool = ..., cov_type: str = ..., cov_kwds: Any | None = ..., return_ssm: bool = ..., results_class: Any | None = ..., results_wrapper_class: Any | None = ..., **kwargs): ...
    def filter(self, params, transformed: bool = ..., includes_fixed: bool = ..., complex_step: bool = ..., cov_type: str = ..., cov_kwds: Any | None = ..., return_ssm: bool = ..., results_class: Any | None = ..., results_wrapper_class: Any | None = ..., low_memory: bool = ..., **kwargs): ...
    def simulate(self, params, nsimulations, measurement_shocks: Any | None = ..., state_shocks: Any | None = ..., initial_state: Any | None = ..., anchor: Any | None = ..., repetitions: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., transformed: bool = ..., includes_fixed: bool = ..., original_scale: bool = ..., **kwargs): ...
    def impulse_responses(self, params, steps: int = ..., impulse: int = ..., orthogonalized: bool = ..., cumulative: bool = ..., anchor: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., transformed: bool = ..., includes_fixed: bool = ..., original_scale: bool = ..., **kwargs): ...

class DynamicFactorMQResults(mlemodel.MLEResults):
    def __init__(self, model, params, filter_results, cov_type: Any | None = ..., **kwargs) -> None: ...
    @property
    def factors(self): ...
    def get_coefficients_of_determination(self, method: str = ..., which: Any | None = ...): ...
    def coefficients_of_determination(self): ...
    def plot_coefficients_of_determination(self, method: str = ..., which: Any | None = ..., endog_labels: Any | None = ..., fig: Any | None = ..., figsize: Any | None = ...): ...
    def get_prediction(self, start: Any | None = ..., end: Any | None = ..., dynamic: bool = ..., index: Any | None = ..., exog: Any | None = ..., extend_model: Any | None = ..., extend_kwargs: Any | None = ..., original_scale: bool = ..., **kwargs): ...
    def news(self, comparison, impact_date: Any | None = ..., impacted_variable: Any | None = ..., start: Any | None = ..., end: Any | None = ..., periods: Any | None = ..., exog: Any | None = ..., comparison_type: Any | None = ..., return_raw: bool = ..., tolerance: float = ..., endog_quarterly: Any | None = ..., original_scale: bool = ..., **kwargs): ...
    def append(self, endog, endog_quarterly: Any | None = ..., refit: bool = ..., fit_kwargs: Any | None = ..., copy_initialization: bool = ..., retain_standardization: bool = ..., **kwargs): ...
    def extend(self, endog, endog_quarterly: Any | None = ..., fit_kwargs: Any | None = ..., retain_standardization: bool = ..., **kwargs): ...
    def apply(self, endog, k_endog_monthly: Any | None = ..., endog_quarterly: Any | None = ..., refit: bool = ..., fit_kwargs: Any | None = ..., copy_initialization: bool = ..., retain_standardization: bool = ..., **kwargs): ...
    def summary(self, alpha: float = ..., start: Any | None = ..., title: Any | None = ..., model_name: Any | None = ..., display_params: bool = ..., display_diagnostics: bool = ..., display_params_as_list: bool = ..., truncate_endog_names: Any | None = ..., display_max_endog: int = ...): ...
