import statsmodels.tsa.base.tsa_model as tsbase
import statsmodels.base.wrapper as wrap
from statsmodels.base.data import PandasData as PandasData
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.eval_measures import aic as aic, bic as bic, hqic as hqic
from statsmodels.tools.numdiff import approx_fprime_cs as approx_fprime_cs, approx_hess_cs as approx_hess_cs
from statsmodels.tools.sm_exceptions import EstimationWarning as EstimationWarning
from statsmodels.tools.tools import Bunch as Bunch, pinv_extended as pinv_extended
from statsmodels.tsa.regime_switching._hamilton_filter import chamilton_filter_log as chamilton_filter_log, dhamilton_filter_log as dhamilton_filter_log, shamilton_filter_log as shamilton_filter_log, zhamilton_filter_log as zhamilton_filter_log
from statsmodels.tsa.regime_switching._kim_smoother import ckim_smoother_log as ckim_smoother_log, dkim_smoother_log as dkim_smoother_log, skim_smoother_log as skim_smoother_log, zkim_smoother_log as zkim_smoother_log
from statsmodels.tsa.statespace.tools import find_best_blas_type as find_best_blas_type, prepare_exog as prepare_exog
from typing import Any

prefix_hamilton_filter_log_map: Any
prefix_kim_smoother_log_map: Any

def cy_hamilton_filter_log(initial_probabilities, regime_transition, conditional_loglikelihoods, model_order): ...
def cy_kim_smoother_log(regime_transition, predicted_joint_probabilities, filtered_joint_probabilities): ...

class MarkovSwitchingParams:
    k_regimes: Any
    k_params: int
    k_parameters: Any
    switching: Any
    slices_purpose: Any
    relative_index_regime_purpose: Any
    index_regime_purpose: Any
    index_regime: Any
    def __init__(self, k_regimes) -> None: ...
    def __getitem__(self, key): ...
    def __setitem__(self, key, value) -> None: ...

class MarkovSwitching(tsbase.TimeSeriesModel):
    k_regimes: Any
    tvtp: Any
    order: Any
    nobs: Any
    parameters: Any
    def __init__(self, endog, k_regimes, order: int = ..., exog_tvtp: Any | None = ..., exog: Any | None = ..., dates: Any | None = ..., freq: Any | None = ..., missing: str = ...) -> None: ...
    @property
    def k_params(self): ...
    def initialize_steady_state(self) -> None: ...
    def initialize_known(self, probabilities, tol: float = ...) -> None: ...
    def initial_probabilities(self, params, regime_transition: Any | None = ...): ...
    def regime_transition_matrix(self, params, exog_tvtp: Any | None = ...): ...
    def predict(self, params, start: Any | None = ..., end: Any | None = ..., probabilities: Any | None = ..., conditional: bool = ...): ...
    def predict_conditional(self, params) -> None: ...
    def filter(self, params, transformed: bool = ..., cov_type: Any | None = ..., cov_kwds: Any | None = ..., return_raw: bool = ..., results_class: Any | None = ..., results_wrapper_class: Any | None = ...): ...
    def smooth(self, params, transformed: bool = ..., cov_type: Any | None = ..., cov_kwds: Any | None = ..., return_raw: bool = ..., results_class: Any | None = ..., results_wrapper_class: Any | None = ...): ...
    def loglikeobs(self, params, transformed: bool = ...): ...
    def loglike(self, params, transformed: bool = ...): ...
    def score(self, params, transformed: bool = ...): ...
    def score_obs(self, params, transformed: bool = ...): ...
    def hessian(self, params, transformed: bool = ...): ...
    def fit(self, start_params: Any | None = ..., transformed: bool = ..., cov_type: str = ..., cov_kwds: Any | None = ..., method: str = ..., maxiter: int = ..., full_output: int = ..., disp: int = ..., callback: Any | None = ..., return_params: bool = ..., em_iter: int = ..., search_reps: int = ..., search_iter: int = ..., search_scale: float = ..., **kwargs): ...
    @property
    def start_params(self): ...
    @property
    def param_names(self): ...
    def transform_params(self, unconstrained): ...
    def untransform_params(self, constrained): ...

class HamiltonFilterResults:
    model: Any
    nobs: Any
    order: Any
    k_regimes: Any
    initialization: Any
    llf_obs: Any
    llf: Any
    regime_transition: Any
    def __init__(self, model, result) -> None: ...
    @property
    def predicted_marginal_probabilities(self): ...
    @property
    def expected_durations(self): ...

class KimSmootherResults(HamiltonFilterResults):
    def __init__(self, model, result) -> None: ...

class MarkovSwitchingResults(tsbase.TimeSeriesModelResults):
    use_t: bool
    data: Any
    filter_results: Any
    smoother_results: Any
    nobs: Any
    order: Any
    k_regimes: Any
    cov_kwds: Any
    cov_type: Any
    cov_params_default: Any
    predicted_marginal_probabilities: Any
    filtered_marginal_probabilities: Any
    smoothed_marginal_probabilities: Any
    expected_durations: Any
    def __init__(self, model, params, results, cov_type: str = ..., cov_kwds: Any | None = ..., **kwargs) -> None: ...
    def aic(self): ...
    def bic(self): ...
    def cov_params_approx(self): ...
    def cov_params_opg(self): ...
    def cov_params_robust(self): ...
    def fittedvalues(self): ...
    def hqic(self): ...
    def llf_obs(self): ...
    def llf(self): ...
    def resid(self): ...
    @property
    def joint_likelihoods(self): ...
    def predict(self, start: Any | None = ..., end: Any | None = ..., probabilities: Any | None = ..., conditional: bool = ...): ...
    def forecast(self, steps: int = ..., **kwargs) -> None: ...
    def summary(self, alpha: float = ..., start: Any | None = ..., title: Any | None = ..., model_name: Any | None = ..., display_params: bool = ...): ...

class MarkovSwitchingResultsWrapper(wrap.ResultsWrapper): ...
