import matplotlib.figure
import numpy as np
import pandas as pd
from statsmodels.iolib.summary import Summary as Summary
from statsmodels.iolib.table import SimpleTable as SimpleTable
from statsmodels.tools.validation import array_like as array_like, bool_like as bool_like, float_like as float_like, int_like as int_like, string_like as string_like
from statsmodels.tsa.deterministic import DeterministicTerm as DeterministicTerm
from statsmodels.tsa.seasonal import seasonal_decompose as seasonal_decompose
from statsmodels.tsa.statespace.exponential_smoothing import ExponentialSmoothing as ExponentialSmoothing
from statsmodels.tsa.statespace.sarimax import SARIMAX as SARIMAX
from statsmodels.tsa.stattools import acf as acf
from statsmodels.tsa.tsatools import add_trend as add_trend, freq_to_period as freq_to_period
from typing import Any, Optional, Tuple

def extend_index(steps: int, index: pd.Index) -> pd.Index: ...

class ThetaModel:
    endog_orig: Any
    def __init__(self, endog, *, period: Optional[int] = ..., deseasonalize: bool = ..., use_test: bool = ..., method: str = ..., difference: bool = ...) -> None: ...
    def fit(self, use_mle: bool = ..., disp: bool = ...) -> ThetaModelResults: ...
    @property
    def deseasonalize(self) -> bool: ...
    @property
    def period(self) -> int: ...
    @property
    def use_test(self) -> bool: ...
    @property
    def difference(self) -> bool: ...
    @property
    def method(self) -> str: ...

class ThetaModelResults:
    def __init__(self, b0: float, alpha: float, sigma2: Optional[float], one_step: float, seasonal: np.ndarray, use_mle: bool, model: ThetaModel) -> None: ...
    @property
    def params(self) -> pd.Series: ...
    @property
    def sigma2(self) -> float: ...
    @property
    def model(self) -> ThetaModel: ...
    def forecast(self, steps: int = ..., theta: float = ...) -> pd.Series: ...
    def forecast_components(self, steps: int = ...) -> pd.DataFrame: ...
    def summary(self) -> Summary: ...
    def prediction_intervals(self, steps: int = ..., theta: float = ..., alpha: float = ...) -> pd.DataFrame: ...
    def plot_predict(self, steps: int = ..., theta: float = ..., alpha: Optional[float] = ..., in_sample: bool = ..., fig: Optional[matplotlib.figure.Figure] = ..., figsize: Tuple[float, float] = ...) -> matplotlib.figure.Figure: ...
