import numpy as np
import pandas as pd
from statsmodels.base.data import PandasData as PandasData
from statsmodels.compat.pandas import Substitution as Substitution, is_int_index as is_int_index
from statsmodels.iolib.summary import SimpleTable as SimpleTable, Summary as Summary
from statsmodels.tools.docstring import Docstring as Docstring, Parameter as Parameter, indent as indent
from statsmodels.tsa.base.prediction import PredictionResults as PredictionResults
from statsmodels.tsa.base.tsa_model import get_index_loc as get_index_loc, get_prediction_index as get_prediction_index
from statsmodels.tsa.seasonal import DecomposeResult as DecomposeResult, STL as STL
from typing import Any, Dict, Optional, Union

DateLike: Any
ds: Any

class STLForecast:
    def __init__(self, endog, model, *, model_kwargs: Any | None = ..., period: Any | None = ..., seasonal: int = ..., trend: Any | None = ..., low_pass: Any | None = ..., seasonal_deg: int = ..., trend_deg: int = ..., low_pass_deg: int = ..., robust: bool = ..., seasonal_jump: int = ..., trend_jump: int = ..., low_pass_jump: int = ...) -> None: ...
    def fit(self, *, inner_iter: Any | None = ..., outer_iter: Any | None = ..., fit_kwargs: Any | None = ...): ...

class STLForecastResults:
    def __init__(self, stl: STL, result: DecomposeResult, model, model_result, endog) -> None: ...
    @property
    def period(self) -> int: ...
    @property
    def stl(self) -> STL: ...
    @property
    def result(self) -> DecomposeResult: ...
    @property
    def model(self) -> Any: ...
    @property
    def model_result(self) -> Any: ...
    def summary(self) -> Summary: ...
    def forecast(self, steps: int = ..., **kwargs: Dict[str, Any]) -> Union[np.ndarray, pd.Series]: ...
    def get_prediction(self, start: Optional[DateLike] = ..., end: Optional[DateLike] = ..., dynamic: Union[bool, DateLike] = ..., **kwargs: Dict[str, Any]): ...
