import statsmodels.base.wrapper as wrap
from statsmodels.base.covtype import descriptions as descriptions
from statsmodels.iolib.summary import forg as forg
from statsmodels.iolib.table import SimpleTable as SimpleTable
from statsmodels.iolib.tableformatting import fmt_params as fmt_params
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.tools import Bunch as Bunch
from statsmodels.tools.validation import array_like as array_like, bool_like as bool_like, int_like as int_like, string_like as string_like
from statsmodels.tsa.exponential_smoothing import base as base
from statsmodels.tsa.tsatools import freq_to_period as freq_to_period
from typing import Any

class ETSModel(base.StateSpaceMLEModel):
    error: Any
    trend: Any
    damped_trend: Any
    seasonal: Any
    has_trend: Any
    has_seasonal: Any
    seasonal_periods: Any
    def __init__(self, endog, error: str = ..., trend: Any | None = ..., damped_trend: bool = ..., seasonal: Any | None = ..., seasonal_periods: Any | None = ..., initialization_method: str = ..., initial_level: Any | None = ..., initial_trend: Any | None = ..., initial_seasonal: Any | None = ..., bounds: Any | None = ..., dates: Any | None = ..., freq: Any | None = ..., missing: str = ...) -> None: ...
    initialization_method: Any
    initial_level: Any
    initial_trend: Any
    initial_seasonal: Any
    def set_initialization_method(self, initialization_method, initial_level: Any | None = ..., initial_trend: Any | None = ..., initial_seasonal: Any | None = ...) -> None: ...
    bounds: Any
    def set_bounds(self, bounds) -> None: ...
    @staticmethod
    def prepare_data(data): ...
    @property
    def nobs_effective(self): ...
    @property
    def k_endog(self): ...
    @property
    def short_name(self): ...
    @property
    def state_names(self): ...
    @property
    def initial_state_names(self): ...
    @property
    def k_params(self): ...
    def fit(self, start_params: Any | None = ..., maxiter: int = ..., full_output: bool = ..., disp: bool = ..., callback: Any | None = ..., return_params: bool = ..., **kwargs): ...
    def use_internal_loglike(self) -> None: ...
    def loglike(self, params, **kwargs): ...
    def smooth(self, params, return_raw: bool = ...): ...
    def hessian(self, params, approx_centered: bool = ..., approx_complex_step: bool = ..., **kwargs): ...
    def score(self, params, approx_centered: bool = ..., approx_complex_step: bool = ..., **kwargs): ...
    def update(params, *args, **kwargs) -> None: ...

class ETSResults(base.StateSpaceMLEResults):
    param_names: Any
    states: Any
    initial_state: Any
    level: Any
    initial_level: Any
    alpha: Any
    smoothing_level: Any
    slope: Any
    initial_trend: Any
    beta: Any
    smoothing_trend: Any
    season: Any
    initial_seasonal: Any
    gamma: Any
    smoothing_seasonal: Any
    phi: Any
    damping_trend: Any
    df_model: Any
    mean_resid: Any
    scale_resid: Any
    standardized_forecasts_error: Any
    cov_kwds: Any
    cov_type: str
    cov_params_default: Any
    def __init__(self, model, params, results) -> None: ...
    def nobs_effective(self): ...
    def fittedvalues(self): ...
    def resid(self): ...
    def llf(self): ...
    def simulate(self, nsimulations, anchor: Any | None = ..., repetitions: int = ..., random_errors: Any | None = ..., random_state: Any | None = ...): ...
    def forecast(self, steps: int = ...): ...
    def predict(self, start: Any | None = ..., end: Any | None = ..., dynamic: bool = ..., index: Any | None = ...): ...
    def get_prediction(self, start: Any | None = ..., end: Any | None = ..., dynamic: bool = ..., index: Any | None = ..., method: Any | None = ..., simulate_repetitions: int = ..., **simulate_kwargs): ...
    def summary(self, alpha: float = ..., start: Any | None = ...): ...

class ETSResultsWrapper(wrap.ResultsWrapper): ...

class PredictionResults:
    use_pandas: Any
    method: Any
    predicted_mean: Any
    row_labels: Any
    endog: Any
    model: Any
    simulation_results: Any
    forecast_variance: Any
    def __init__(self, results, start: Any | None = ..., end: Any | None = ..., dynamic: bool = ..., index: Any | None = ..., method: Any | None = ..., simulate_repetitions: int = ..., **simulate_kwargs) -> None: ...
    @property
    def var_pred_mean(self): ...
    def pred_int(self, alpha: float = ...): ...
    def summary_frame(self, endog: int = ..., alpha: float = ...): ...

class PredictionResultsWrapper(wrap.ResultsWrapper): ...
