import statsmodels.tsa.base.tsa_model as tsbase
from statsmodels.base.data import PandasData as PandasData
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.eval_measures import aic as aic, aicc as aicc, bic as bic, hqic as hqic
from statsmodels.tools.numdiff import approx_fprime as approx_fprime, approx_fprime_cs as approx_fprime_cs, approx_hess_cs as approx_hess_cs
from statsmodels.tools.sm_exceptions import PrecisionWarning as PrecisionWarning
from statsmodels.tools.tools import pinv_extended as pinv_extended
from typing import Any

class StateSpaceMLEModel(tsbase.TimeSeriesModel):
    use_pandas: Any
    nobs: Any
    def __init__(self, endog, exog: Any | None = ..., dates: Any | None = ..., freq: Any | None = ..., missing: str = ..., **kwargs) -> None: ...
    @staticmethod
    def prepare_data(data) -> None: ...
    def clone(self, endog, exog: Any | None = ..., **kwargs) -> None: ...
    @property
    def k_params(self): ...
    def fix_params(self, params) -> None: ...
    def fit_constrained(self, constraints, start_params: Any | None = ..., **fit_kwds): ...
    @property
    def start_params(self): ...
    @property
    def param_names(self): ...
    @classmethod
    def from_formula(cls, formula, data, subset: Any | None = ..., drop_cols: Any | None = ..., *args, **kwargs) -> None: ...

class StateSpaceMLEResults(tsbase.TimeSeriesModelResults):
    data: Any
    endog: Any
    fixed_params: Any
    param_names: Any
    nobs: Any
    k_params: Any
    def __init__(self, model, params, scale: float = ...) -> None: ...
    def nobs_effective(self) -> None: ...
    def df_resid(self): ...
    def aic(self): ...
    def aicc(self): ...
    def bic(self): ...
    def fittedvalues(self) -> None: ...
    def hqic(self): ...
    def llf(self) -> None: ...
    def mae(self): ...
    def mse(self): ...
    def pvalues(self): ...
    def resid(self) -> None: ...
    def sse(self): ...
    def zvalues(self): ...
    def cov_params_approx(self): ...
    def test_serial_correlation(self, method, lags: Any | None = ...): ...
    def test_heteroskedasticity(self, method, alternative: str = ..., use_f: bool = ...): ...
    def test_normality(self, method): ...
    def summary(self, alpha: float = ..., start: Any | None = ..., title: Any | None = ..., model_name: Any | None = ..., display_params: bool = ...): ...
