from statsmodels.tsa.arima.tools import standardize_lag_order as standardize_lag_order, validate_basic as validate_basic
from statsmodels.tsa.base.tsa_model import TimeSeriesModel as TimeSeriesModel
from statsmodels.tsa.statespace.tools import is_invertible as is_invertible, prepare_exog as prepare_exog, prepare_trend_data as prepare_trend_data, prepare_trend_spec as prepare_trend_spec
from typing import Any

class SARIMAXSpecification:
    enforce_stationarity: Any
    enforce_invertibility: Any
    concentrate_scale: Any
    trend_offset: Any
    order: Any
    seasonal_order: Any
    ar_lags: Any
    ma_lags: Any
    seasonal_ar_lags: Any
    seasonal_ma_lags: Any
    max_ar_order: Any
    max_ma_order: Any
    max_seasonal_ar_order: Any
    max_seasonal_ma_order: Any
    max_reduced_ar_order: Any
    max_reduced_ma_order: Any
    trend: Any
    trend_terms: Any
    k_trend: Any
    trend_order: Any
    trend_degree: Any
    endog: Any
    exog: Any
    def __init__(self, endog: Any | None = ..., exog: Any | None = ..., order: Any | None = ..., seasonal_order: Any | None = ..., ar_order: Any | None = ..., diff: Any | None = ..., ma_order: Any | None = ..., seasonal_ar_order: Any | None = ..., seasonal_diff: Any | None = ..., seasonal_ma_order: Any | None = ..., seasonal_periods: Any | None = ..., trend: Any | None = ..., enforce_stationarity: Any | None = ..., enforce_invertibility: Any | None = ..., concentrate_scale: Any | None = ..., trend_offset: int = ..., dates: Any | None = ..., freq: Any | None = ..., missing: str = ..., validate_specification: bool = ...) -> None: ...
    @property
    def is_ar_consecutive(self): ...
    @property
    def is_ma_consecutive(self): ...
    @property
    def is_integrated(self): ...
    @property
    def is_seasonal(self): ...
    @property
    def k_exog_params(self): ...
    @property
    def k_ar_params(self): ...
    @property
    def k_ma_params(self): ...
    @property
    def k_seasonal_ar_params(self): ...
    @property
    def k_seasonal_ma_params(self): ...
    @property
    def k_params(self): ...
    @property
    def exog_names(self): ...
    @property
    def ar_names(self): ...
    @property
    def ma_names(self): ...
    @property
    def seasonal_ar_names(self): ...
    @property
    def seasonal_ma_names(self): ...
    @property
    def param_names(self): ...
    @property
    def valid_estimators(self): ...
    def validate_estimator(self, estimator) -> None: ...
    def split_params(self, params, allow_infnan: bool = ...): ...
    def join_params(self, exog_params: Any | None = ..., ar_params: Any | None = ..., ma_params: Any | None = ..., seasonal_ar_params: Any | None = ..., seasonal_ma_params: Any | None = ..., sigma2: Any | None = ...): ...
    def validate_params(self, params) -> None: ...
    def constrain_params(self, unconstrained): ...
    def unconstrain_params(self, constrained): ...
    def construct_trend_data(self, nobs, offset: int = ...): ...
    def construct_trend_names(self): ...
