from statsmodels.tools.rootfinding import brentq_expanding as brentq_expanding
from typing import Any

def ttest_power(effect_size, nobs, alpha, df: Any | None = ..., alternative: str = ...): ...
def normal_power(effect_size, nobs, alpha, alternative: str = ..., sigma: float = ...): ...
def normal_power_het(diff, nobs, alpha, std_null: float = ..., std_alternative: Any | None = ..., alternative: str = ...): ...
def normal_sample_size_one_tail(diff, power, alpha, std_null: float = ..., std_alternative: Any | None = ...): ...
def ftest_anova_power(effect_size, nobs, alpha, k_groups: int = ..., df: Any | None = ...): ...
def ftest_power(effect_size, df_num, df_denom, alpha, ncc: int = ...): ...

class Power:
    start_ttp: Any
    start_bqexp: Any
    def __init__(self, **kwds) -> None: ...
    def power(self, *args, **kwds) -> None: ...
    cache_fit_res: Any
    def solve_power(self, **kwds): ...
    def plot_power(self, dep_var: str = ..., nobs: Any | None = ..., effect_size: Any | None = ..., alpha: float = ..., ax: Any | None = ..., title: Any | None = ..., plt_kwds: Any | None = ..., **kwds): ...

class TTestPower(Power):
    def power(self, effect_size, nobs, alpha, df: Any | None = ..., alternative: str = ...): ...
    def solve_power(self, effect_size: Any | None = ..., nobs: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., alternative: str = ...): ...

class TTestIndPower(Power):
    def power(self, effect_size, nobs1, alpha, ratio: int = ..., df: Any | None = ..., alternative: str = ...): ...
    def solve_power(self, effect_size: Any | None = ..., nobs1: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., ratio: float = ..., alternative: str = ...): ...

class NormalIndPower(Power):
    ddof: Any
    def __init__(self, ddof: int = ..., **kwds) -> None: ...
    def power(self, effect_size, nobs1, alpha, ratio: int = ..., alternative: str = ...): ...
    def solve_power(self, effect_size: Any | None = ..., nobs1: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., ratio: float = ..., alternative: str = ...): ...

class FTestPower(Power):
    def power(self, effect_size, df_num, df_denom, alpha, ncc: int = ...): ...
    def solve_power(self, effect_size: Any | None = ..., df_num: Any | None = ..., df_denom: Any | None = ..., nobs: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., ncc: int = ...): ...

class FTestAnovaPower(Power):
    def power(self, effect_size, nobs, alpha, k_groups: int = ...): ...
    def solve_power(self, effect_size: Any | None = ..., nobs: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., k_groups: int = ...): ...

class GofChisquarePower(Power):
    def power(self, effect_size, nobs, alpha, n_bins, ddof: int = ...): ...
    def solve_power(self, effect_size: Any | None = ..., nobs: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., n_bins: int = ...): ...

class _GofChisquareIndPower(Power):
    def power(self, effect_size, nobs1, alpha, ratio: int = ..., alternative: str = ...): ...
    def solve_power(self, effect_size: Any | None = ..., nobs1: Any | None = ..., alpha: Any | None = ..., power: Any | None = ..., ratio: float = ..., alternative: str = ...): ...

tt_solve_power: Any
tt_ind_solve_power: Any
zt_ind_solve_power: Any
