from statsmodels.compat.pandas import Appender as Appender
from statsmodels.compat.python import lzip as lzip
from statsmodels.regression.linear_model import OLS as OLS
from statsmodels.stats.multitest import multipletests as multipletests
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.tools import maybe_unwrap_results as maybe_unwrap_results
from typing import Any

def outlier_test(model_results, method: str = ..., alpha: float = ..., labels: Any | None = ..., order: bool = ..., cutoff: Any | None = ...): ...
def reset_ramsey(res, degree: int = ...): ...
def variance_inflation_factor(exog, exog_idx): ...

class _BaseInfluenceMixin:
    def plot_influence(self, external: Any | None = ..., alpha: float = ..., criterion: str = ..., size: int = ..., plot_alpha: float = ..., ax: Any | None = ..., **kwargs): ...
    def plot_index(self, y_var: str = ..., threshold: Any | None = ..., title: Any | None = ..., ax: Any | None = ..., idx: Any | None = ..., **kwds): ...

class MLEInfluence(_BaseInfluenceMixin):
    results: Any
    endog: Any
    exog: Any
    resid: Any
    scale: Any
    cov_params: Any
    model_class: Any
    hessian: Any
    score_obs: Any
    def __init__(self, results, resid: Any | None = ..., endog: Any | None = ..., exog: Any | None = ..., hat_matrix_diag: Any | None = ..., cov_params: Any | None = ..., scale: Any | None = ...) -> None: ...
    def hat_matrix_diag(self): ...
    def d_params(self): ...
    def dfbetas(self): ...
    def params_one(self): ...
    def cooks_distance(self): ...
    def resid_studentized(self): ...
    def d_fittedvalues(self): ...
    @property
    def d_fittedvalues_scaled(self): ...
    def summary_frame(self): ...

class OLSInfluence(_BaseInfluenceMixin):
    results: Any
    endog: Any
    exog: Any
    resid: Any
    model_class: Any
    scale: Any
    aux_regression_exog: Any
    aux_regression_endog: Any
    def __init__(self, results) -> None: ...
    def hat_matrix_diag(self): ...
    def resid_press(self): ...
    def influence(self): ...
    def hat_diag_factor(self): ...
    def ess_press(self): ...
    def resid_studentized(self): ...
    def resid_studentized_internal(self): ...
    def resid_studentized_external(self): ...
    def get_resid_studentized_external(self, sigma: Any | None = ...): ...
    def cooks_distance(self): ...
    def dffits_internal(self): ...
    def dffits(self): ...
    def dfbetas(self): ...
    def dfbeta(self): ...
    def sigma2_not_obsi(self): ...
    @property
    def params_not_obsi(self): ...
    @property
    def det_cov_params_not_obsi(self): ...
    def cov_ratio(self): ...
    def resid_var(self): ...
    def resid_std(self): ...
    def summary_frame(self): ...
    table_data: Any
    def summary_table(self, float_fmt: str = ...): ...

def summary_table(res, alpha: float = ...): ...

class GLMInfluence(MLEInfluence):
    def hat_matrix_diag(self): ...
    def d_params(self): ...
    def resid_studentized(self): ...
    def cooks_distance(self): ...
    @property
    def d_linpred(self): ...
    @property
    def d_linpred_scaled(self): ...
