from statsmodels import iolib as iolib
from statsmodels.tools import sm_exceptions as sm_exceptions
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from typing import Any

class _Bunch: ...

class Table:
    table_orig: Any
    table: Any
    def __init__(self, table, shift_zeros: bool = ...) -> None: ...
    @classmethod
    def from_data(cls, data, shift_zeros: bool = ...): ...
    def test_nominal_association(self): ...
    def test_ordinal_association(self, row_scores: Any | None = ..., col_scores: Any | None = ...): ...
    def marginal_probabilities(self): ...
    def independence_probabilities(self): ...
    def fittedvalues(self): ...
    def resid_pearson(self): ...
    def standardized_resids(self): ...
    def chi2_contribs(self): ...
    def local_log_oddsratios(self): ...
    def local_oddsratios(self): ...
    def cumulative_log_oddsratios(self): ...
    def cumulative_oddsratios(self): ...

class SquareTable(Table):
    def __init__(self, table, shift_zeros: bool = ...) -> None: ...
    def symmetry(self, method: str = ...): ...
    def homogeneity(self, method: str = ...): ...
    def summary(self, alpha: float = ..., float_format: str = ...): ...

class Table2x2(SquareTable):
    def __init__(self, table, shift_zeros: bool = ...) -> None: ...
    @classmethod
    def from_data(cls, data, shift_zeros: bool = ...): ...
    def log_oddsratio(self): ...
    def oddsratio(self): ...
    def log_oddsratio_se(self): ...
    def oddsratio_pvalue(self, null: int = ...): ...
    def log_oddsratio_pvalue(self, null: int = ...): ...
    def log_oddsratio_confint(self, alpha: float = ..., method: str = ...): ...
    def oddsratio_confint(self, alpha: float = ..., method: str = ...): ...
    def riskratio(self): ...
    def log_riskratio(self): ...
    def log_riskratio_se(self): ...
    def riskratio_pvalue(self, null: int = ...): ...
    def log_riskratio_pvalue(self, null: int = ...): ...
    def log_riskratio_confint(self, alpha: float = ..., method: str = ...): ...
    def riskratio_confint(self, alpha: float = ..., method: str = ...): ...
    def summary(self, alpha: float = ..., float_format: str = ..., method: str = ...): ...

class StratifiedTable:
    table: Any
    def __init__(self, tables, shift_zeros: bool = ...) -> None: ...
    @classmethod
    def from_data(cls, var1, var2, strata, data): ...
    def test_null_odds(self, correction: bool = ...): ...
    def oddsratio_pooled(self): ...
    def logodds_pooled(self): ...
    def riskratio_pooled(self): ...
    def logodds_pooled_se(self): ...
    def logodds_pooled_confint(self, alpha: float = ..., method: str = ...): ...
    def oddsratio_pooled_confint(self, alpha: float = ..., method: str = ...): ...
    def test_equal_odds(self, adjust: bool = ...): ...
    def summary(self, alpha: float = ..., float_format: str = ..., method: str = ...): ...

def mcnemar(table, exact: bool = ..., correction: bool = ...): ...
def cochrans_q(x, return_object: bool = ...): ...
