from typing import Any

class Diffusion:
    def __init__(self) -> None: ...
    dW: Any
    def simulateW(self, nobs: int = ..., T: int = ..., dt: Any | None = ..., nrepl: int = ...): ...
    def expectedsim(self, func, nobs: int = ..., T: int = ..., dt: Any | None = ..., nrepl: int = ...): ...

class AffineDiffusion(Diffusion):
    def __init__(self) -> None: ...
    def sim(self, nobs: int = ..., T: int = ..., dt: Any | None = ..., nrepl: int = ...): ...
    def simEM(self, xzero: Any | None = ..., nobs: int = ..., T: int = ..., dt: Any | None = ..., nrepl: int = ..., Tratio: int = ...): ...

class ExactDiffusion(AffineDiffusion):
    def __init__(self) -> None: ...
    def exactprocess(self, xzero, nobs, ddt: float = ..., nrepl: int = ...): ...
    def exactdist(self, xzero, t): ...

class ArithmeticBrownian(AffineDiffusion):
    xzero: Any
    mu: Any
    sigma: Any
    def __init__(self, xzero, mu, sigma) -> None: ...
    def exactprocess(self, nobs, xzero: Any | None = ..., ddt: float = ..., nrepl: int = ...): ...
    def exactdist(self, xzero, t): ...

class GeometricBrownian(AffineDiffusion):
    xzero: Any
    mu: Any
    sigma: Any
    def __init__(self, xzero, mu, sigma) -> None: ...

class OUprocess(AffineDiffusion):
    xzero: Any
    lambd: Any
    mu: Any
    sigma: Any
    def __init__(self, xzero, mu, lambd, sigma) -> None: ...
    def exact(self, xzero, t, normrvs): ...
    def exactprocess(self, xzero, nobs, ddt: float = ..., nrepl: int = ...): ...
    def exactdist(self, xzero, t): ...
    def fitls(self, data, dt): ...

class SchwartzOne(ExactDiffusion):
    xzero: Any
    mu: Any
    kappa: Any
    lambd: Any
    sigma: Any
    def __init__(self, xzero, mu, kappa, sigma) -> None: ...
    def exactprocess(self, xzero, nobs, ddt: float = ..., nrepl: int = ...): ...
    def exactdist(self, xzero, t): ...
    def fitls(self, data, dt): ...

class BrownianBridge:
    def __init__(self) -> None: ...
    def simulate(self, x0, x1, nobs, nrepl: int = ..., ddt: float = ..., sigma: float = ...): ...

class CompoundPoisson:
    nobj: Any
    randfn: Any
    lambd: Any
    def __init__(self, lambd, randfn=...) -> None: ...
    def simulate(self, nobs, nrepl: int = ...): ...
