from typing import Any

class RobustNorm:
    def rho(self, z) -> None: ...
    def psi(self, z) -> None: ...
    def weights(self, z) -> None: ...
    def psi_deriv(self, z) -> None: ...
    def __call__(self, z): ...

class LeastSquares(RobustNorm):
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

class HuberT(RobustNorm):
    t: Any
    def __init__(self, t: float = ...) -> None: ...
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

class RamsayE(RobustNorm):
    a: Any
    def __init__(self, a: float = ...) -> None: ...
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

class AndrewWave(RobustNorm):
    a: Any
    def __init__(self, a: float = ...) -> None: ...
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

class TrimmedMean(RobustNorm):
    c: Any
    def __init__(self, c: float = ...) -> None: ...
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

class Hampel(RobustNorm):
    a: Any
    b: Any
    c: Any
    def __init__(self, a: float = ..., b: float = ..., c: float = ...) -> None: ...
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

class TukeyBiweight(RobustNorm):
    c: Any
    def __init__(self, c: float = ...) -> None: ...
    def rho(self, z): ...
    def psi(self, z): ...
    def weights(self, z): ...
    def psi_deriv(self, z): ...

def estimate_location(a, scale, norm: Any | None = ..., axis: int = ..., initial: Any | None = ..., maxiter: int = ..., tol: float = ...): ...
