import statsmodels.base.model as base
from statsmodels.iolib import summary2 as summary2
from statsmodels.regression.linear_model import OLS as OLS
from statsmodels.tools.numdiff import approx_fprime as approx_fprime
from typing import Any

class ProcessCovariance:
    def get_cov(self, time, sc, sm) -> None: ...
    def jac(self, time, sc, sm) -> None: ...

class GaussianCovariance(ProcessCovariance):
    def get_cov(self, time, sc, sm): ...
    def jac(self, time, sc, sm): ...

class ProcessMLE(base.LikelihoodModel):
    cov: Any
    verbose: bool
    k_exog: Any
    k_scale: Any
    k_smooth: Any
    k_noise: Any
    def __init__(self, endog, exog, exog_scale, exog_smooth, exog_noise, time, groups, cov: Any | None = ..., **kwargs): ...
    @classmethod
    def from_formula(cls, formula, data, subset: Any | None = ..., drop_cols: Any | None = ..., *args, **kwargs): ...
    def unpack(self, z): ...
    def loglike(self, params): ...
    def score(self, params): ...
    def hessian(self, params): ...
    def fit(self, start_params: Any | None = ..., method: Any | None = ..., maxiter: Any | None = ..., **kwargs): ...
    def covariance(self, time, scale_params, smooth_params, scale_data, smooth_data): ...
    def predict(self, params, exog: Any | None = ..., *args, **kwargs): ...

class ProcessMLEResults(base.GenericLikelihoodModelResults):
    mean_params: Any
    scale_params: Any
    smooth_params: Any
    no_params: Any
    df_resid: Any
    k_exog: Any
    k_scale: Any
    k_smooth: Any
    k_noise: Any
    def __init__(self, model, mlefit) -> None: ...
    def predict(self, exog: Any | None = ..., transform: bool = ..., *args, **kwargs): ...
    def covariance(self, time, scale, smooth): ...
    def covariance_group(self, group): ...
    def summary(self, yname: Any | None = ..., xname: Any | None = ..., title: Any | None = ..., alpha: float = ...): ...
