import statsmodels.base.model as base
import statsmodels.base.wrapper as wrap
from statsmodels.regression._prediction import PredictionResults as PredictionResults
from typing import Any, Sequence

class RegressionModel(base.LikelihoodModel):
    def __init__(self, endog, exog, **kwargs) -> None: ...
    wexog: Any
    wendog: Any
    nobs: Any
    rank: Any
    def initialize(self) -> None: ...
    @property
    def df_model(self): ...
    @df_model.setter
    def df_model(self, value) -> None: ...
    @property
    def df_resid(self): ...
    @df_resid.setter
    def df_resid(self, value) -> None: ...
    def whiten(self, x) -> None: ...
    normalized_cov_params: Any
    wexog_singular_values: Any
    effects: Any
    def fit(self, method: str = ..., cov_type: str = ..., cov_kwds: Any | None = ..., use_t: Any | None = ..., **kwargs): ...
    def predict(self, params, exog: Any | None = ...): ...
    def get_distribution(self, params, scale, exog: Any | None = ..., dist_class: Any | None = ...): ...

class GLS(RegressionModel):
    __doc__: Any
    def __init__(self, endog, exog, sigma: Any | None = ..., missing: str = ..., hasconst: Any | None = ..., **kwargs) -> None: ...
    def whiten(self, x): ...
    def loglike(self, params): ...
    def hessian_factor(self, params, scale: Any | None = ..., observed: bool = ...): ...
    def fit_regularized(self, method: str = ..., alpha: float = ..., L1_wt: float = ..., start_params: Any | None = ..., profile_scale: bool = ..., refit: bool = ..., **kwargs): ...

class WLS(RegressionModel):
    __doc__: Any
    def __init__(self, endog, exog, weights: float = ..., missing: str = ..., hasconst: Any | None = ..., **kwargs) -> None: ...
    def whiten(self, x): ...
    def loglike(self, params): ...
    def hessian_factor(self, params, scale: Any | None = ..., observed: bool = ...): ...
    def fit_regularized(self, method: str = ..., alpha: float = ..., L1_wt: float = ..., start_params: Any | None = ..., profile_scale: bool = ..., refit: bool = ..., **kwargs): ...

class OLS(WLS):
    __doc__: Any
    def __init__(self, endog, exog: Any | None = ..., missing: str = ..., hasconst: Any | None = ..., **kwargs) -> None: ...
    def loglike(self, params, scale: Any | None = ...): ...
    def whiten(self, x): ...
    def score(self, params, scale: Any | None = ...): ...
    def hessian(self, params, scale: Any | None = ...): ...
    def hessian_factor(self, params, scale: Any | None = ..., observed: bool = ...): ...
    def fit_regularized(self, method: str = ..., alpha: float = ..., L1_wt: float = ..., start_params: Any | None = ..., profile_scale: bool = ..., refit: bool = ..., **kwargs): ...

class GLSAR(GLS):
    __doc__: Any
    order: Any
    rho: Any
    def __init__(self, endog, exog: Any | None = ..., rho: int = ..., missing: str = ..., hasconst: Any | None = ..., **kwargs) -> None: ...
    def iterative_fit(self, maxiter: int = ..., rtol: float = ..., **kwargs): ...
    def whiten(self, x): ...

class RegressionResults(base.LikelihoodModelResults):
    df_model: Any
    df_resid: Any
    cov_type: str
    cov_kwds: Any
    use_t: Any
    def __init__(self, model, params, normalized_cov_params: Any | None = ..., scale: float = ..., cov_type: str = ..., cov_kwds: Any | None = ..., use_t: Any | None = ..., **kwargs) -> None: ...
    def conf_int(self, alpha: float = ..., cols: Any | None = ...): ...
    def nobs(self): ...
    def fittedvalues(self): ...
    def wresid(self): ...
    def resid(self): ...
    def scale(self): ...
    def ssr(self): ...
    def centered_tss(self): ...
    def uncentered_tss(self): ...
    def ess(self): ...
    def rsquared(self): ...
    def rsquared_adj(self): ...
    def mse_model(self): ...
    def mse_resid(self): ...
    def mse_total(self): ...
    def fvalue(self): ...
    def f_pvalue(self): ...
    def bse(self): ...
    def aic(self): ...
    def bic(self): ...
    def info_criteria(self, crit, dk_params: int = ...): ...
    def eigenvals(self): ...
    def condition_number(self): ...
    het_scale: Any
    def cov_HC0(self): ...
    def cov_HC1(self): ...
    def cov_HC2(self): ...
    def cov_HC3(self): ...
    def HC0_se(self): ...
    def HC1_se(self): ...
    def HC2_se(self): ...
    def HC3_se(self): ...
    def resid_pearson(self): ...
    def compare_lm_test(self, restricted, demean: bool = ..., use_lr: bool = ...): ...
    def compare_f_test(self, restricted): ...
    def compare_lr_test(self, restricted, large_sample: bool = ...): ...
    n_groups: Any
    def get_robustcov_results(self, cov_type: str = ..., use_t: Any | None = ..., **kwargs): ...
    def get_prediction(self, exog: Any | None = ..., transform: bool = ..., weights: Any | None = ..., row_labels: Any | None = ..., **kwargs): ...
    diagn: Any
    def summary(self, yname: Union[str, None] = ..., xname: Union[Sequence[str], None] = ..., title: Union[str, None] = ..., alpha: float = ..., slim: bool = ...): ...
    def summary2(self, yname: Union[str, None] = ..., xname: Union[Sequence[str], None] = ..., title: Union[str, None] = ..., alpha: float = ..., float_format: str = ...): ...

class OLSResults(RegressionResults):
    def get_influence(self): ...
    def outlier_test(self, method: str = ..., alpha: float = ..., labels: Any | None = ..., order: bool = ..., cutoff: Any | None = ...): ...
    def el_test(self, b0_vals, param_nums, return_weights: int = ..., ret_params: int = ..., method: str = ..., stochastic_exog: int = ...): ...
    def conf_int_el(self, param_num, sig: float = ..., upper_bound: Any | None = ..., lower_bound: Any | None = ..., method: str = ..., stochastic_exog: bool = ...): ...

class RegressionResultsWrapper(wrap.ResultsWrapper): ...
