import statsmodels.regression.linear_model as lm
from statsmodels.base.model import GenericLikelihoodModel as GenericLikelihoodModel, GenericLikelihoodModelResults as GenericLikelihoodModelResults, _LLRMixin
from statsmodels.genmod import families as families
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from typing import Any

class BetaModel(GenericLikelihoodModel):
    __doc__: Any
    link: Any
    link_precision: Any
    nobs: Any
    df_model: Any
    df_resid: Any
    hess_type: str
    results_class: Any
    results_class_wrapper: Any
    def __init__(self, endog, exog, exog_precision: Any | None = ..., link=..., link_precision=..., **kwds) -> None: ...
    @classmethod
    def from_formula(cls, formula, data, exog_precision_formula: Any | None = ..., *args, **kwargs): ...
    def predict(self, params, exog: Any | None = ..., exog_precision: Any | None = ..., which: str = ...): ...
    def predict_precision(self, params, exog_precision: Any | None = ...): ...
    def predict_var(self, params, exog: Any | None = ..., exog_precision: Any | None = ...): ...
    def loglikeobs(self, params): ...
    def score(self, params): ...
    def score_factor(self, params): ...
    def score_hessian_factor(self, params, return_hessian: bool = ..., observed: bool = ...): ...
    def score_obs(self, params): ...
    def hessian(self, params, observed: Any | None = ...): ...
    def fit(self, start_params: Any | None = ..., maxiter: int = ..., disp: bool = ..., method: str = ..., **kwds): ...
    def get_distribution_params(self, params, exog: Any | None = ..., exog_precision: Any | None = ...): ...
    def get_distribution(self, params, exog: Any | None = ..., exog_precision: Any | None = ...): ...

class BetaResults(GenericLikelihoodModelResults, _LLRMixin):
    def fittedvalues(self): ...
    def fitted_precision(self): ...
    def resid(self): ...
    def resid_pearson(self): ...
    def prsquared(self): ...
    def get_distribution_params(self, exog: Any | None = ..., exog_precision: Any | None = ..., transform: bool = ...): ...
    def get_distribution(self, exog: Any | None = ..., exog_precision: Any | None = ..., transform: bool = ...): ...
    def bootstrap(self, *args, **kwargs) -> None: ...

class BetaResultsWrapper(lm.RegressionResultsWrapper): ...
