import statsmodels.base.model as base
import statsmodels.regression.linear_model as lm
from statsmodels.genmod import families as families
from statsmodels.genmod.families import links as links, varfuncs as varfuncs
from statsmodels.genmod.generalized_linear_model import GLM as GLM
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from typing import Any

class QIFCovariance:
    def mat(self, dim, term) -> None: ...

class QIFIndependence(QIFCovariance):
    num_terms: int
    def __init__(self) -> None: ...
    def mat(self, dim, term): ...

class QIFExchangeable(QIFCovariance):
    num_terms: int
    def __init__(self) -> None: ...
    def mat(self, dim, term): ...

class QIFAutoregressive(QIFCovariance):
    num_terms: int
    def __init__(self) -> None: ...
    def mat(self, dim, term): ...

class QIF(base.Model):
    family: Any
    cov_struct: Any
    group_names: Any
    nobs: Any
    groups_ix: Any
    def __init__(self, endog, exog, groups, family: Any | None = ..., cov_struct: Any | None = ..., missing: str = ..., **kwargs) -> None: ...
    def objective(self, params): ...
    def estimate_scale(self, params): ...
    @classmethod
    def from_formula(cls, formula, groups, data, subset: Any | None = ..., *args, **kwargs): ...
    ddof_scale: Any
    def fit(self, maxiter: int = ..., start_params: Any | None = ..., tol: float = ..., gtol: float = ..., ddof_scale: Any | None = ...): ...

class QIFResults(base.LikelihoodModelResults):
    def __init__(self, model, params, cov_params, scale, use_t: bool = ..., **kwds) -> None: ...
    def aic(self): ...
    def bic(self): ...
    def fittedvalues(self): ...
    def summary(self, yname: Any | None = ..., xname: Any | None = ..., title: Any | None = ..., alpha: float = ...): ...

class QIFResultsWrapper(lm.RegressionResultsWrapper): ...
