import statsmodels.regression.linear_model as lm
from statsmodels.compat.pandas import Appender as Appender
from statsmodels.compat.python import lzip as lzip
from statsmodels.discrete.discrete_margins import margeff_cov_with_se as margeff_cov_with_se
from statsmodels.genmod import families as families
from statsmodels.genmod.families.links import Link as Link
from statsmodels.genmod.generalized_linear_model import GLM as GLM, GLMResults as GLMResults
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.sm_exceptions import ConvergenceWarning as ConvergenceWarning, DomainWarning as DomainWarning, IterationLimitWarning as IterationLimitWarning, ValueWarning as ValueWarning
from typing import Any

class ParameterConstraint:
    lhs: Any
    rhs: Any
    lhs0: Any
    lhs1: Any
    lhsf: Any
    param0: Any
    orig_exog: Any
    exog_fulltrans: Any
    def __init__(self, lhs, rhs, exog) -> None: ...
    def offset_increment(self): ...
    def reduced_exog(self): ...
    def restore_exog(self): ...
    def unpack_param(self, params): ...
    def unpack_cov(self, bcov): ...

class GEE(GLM):
    __doc__: Any
    cached_means: Any
    missing: Any
    dep_data: Any
    constraint: Any
    update_dep: Any
    family: Any
    cov_struct: Any
    exog: Any
    group_indices: Any
    group_labels: Any
    endog_li: Any
    exog_li: Any
    weights_li: Any
    num_group: Any
    time: Any
    time_li: Any
    offset_li: Any
    nobs: Any
    df_model: Any
    df_resid: Any
    def __init__(self, endog, exog, groups, time: Any | None = ..., family: Any | None = ..., cov_struct: Any | None = ..., missing: str = ..., offset: Any | None = ..., exposure: Any | None = ..., dep_data: Any | None = ..., constraint: Any | None = ..., update_dep: bool = ..., weights: Any | None = ..., **kwargs) -> None: ...
    @classmethod
    def from_formula(cls, formula, groups, data, subset: Any | None = ..., time: Any | None = ..., offset: Any | None = ..., exposure: Any | None = ..., *args, **kwargs): ...
    def cluster_list(self, array): ...
    scaletype: Any
    ddof_scale: Any
    scaling_factor: int
    def compare_score_test(self, submodel): ...
    def estimate_scale(self): ...
    def mean_deriv(self, exog, lin_pred): ...
    def mean_deriv_exog(self, exog, params, offset_exposure: Any | None = ...): ...
    def update_cached_means(self, mean_params) -> None: ...
    fit_history: Any
    def fit(self, maxiter: int = ..., ctol: float = ..., start_params: Any | None = ..., params_niter: int = ..., first_dep_update: int = ..., cov_type: str = ..., ddof_scale: Any | None = ..., scaling_factor: float = ..., scale: Any | None = ...): ...
    def fit_regularized(self, pen_wt, scad_param: float = ..., maxiter: int = ..., ddof_scale: Any | None = ..., update_assoc: int = ..., ctol: float = ..., ztol: float = ..., eps: float = ..., scale: Any | None = ...): ...
    def qic(self, params, scale, cov_params, n_step: int = ...): ...

class GEEResults(GLMResults):
    __doc__: Any
    df_resid: Any
    df_model: Any
    family: Any
    cov_type: Any
    cov_params_default: Any
    def __init__(self, model, params, cov_params, scale, cov_type: str = ..., use_t: bool = ..., regularized: bool = ..., **kwds) -> None: ...
    def resid(self): ...
    def standard_errors(self, cov_type: str = ...): ...
    def bse(self): ...
    def score_test(self): ...
    def resid_split(self): ...
    def resid_centered(self): ...
    def resid_centered_split(self): ...
    def qic(self, scale: Any | None = ..., n_step: int = ...): ...
    split_resid: Any
    centered_resid: Any
    split_centered_resid: Any
    def plot_added_variable(self, focus_exog, resid_type: Any | None = ..., use_glm_weights: bool = ..., fit_kwargs: Any | None = ..., ax: Any | None = ...): ...
    def plot_partial_residuals(self, focus_exog, ax: Any | None = ...): ...
    def plot_ceres_residuals(self, focus_exog, frac: float = ..., cond_means: Any | None = ..., ax: Any | None = ...): ...
    def conf_int(self, alpha: float = ..., cols: Any | None = ..., cov_type: Any | None = ...): ...
    def summary(self, yname: Any | None = ..., xname: Any | None = ..., title: Any | None = ..., alpha: float = ...): ...
    def get_margeff(self, at: str = ..., method: str = ..., atexog: Any | None = ..., dummy: bool = ..., count: bool = ...): ...
    def plot_isotropic_dependence(self, ax: Any | None = ..., xpoints: int = ..., min_n: int = ...): ...
    def sensitivity_params(self, dep_params_first, dep_params_last, num_steps): ...
    params_sensitivity: Any

class GEEResultsWrapper(lm.RegressionResultsWrapper): ...

class OrdinalGEE(GEE):
    __doc__: Any
    def __init__(self, endog, exog, groups, time: Any | None = ..., family: Any | None = ..., cov_struct: Any | None = ..., missing: str = ..., offset: Any | None = ..., dep_data: Any | None = ..., constraint: Any | None = ..., **kwargs) -> None: ...
    endog_orig: Any
    exog_orig: Any
    groups_orig: Any
    offset_orig: Any
    time_orig: Any
    endog_values: Any
    def setup_ordinal(self, endog, exog, groups, time, offset): ...
    def fit(self, maxiter: int = ..., ctol: float = ..., start_params: Any | None = ..., params_niter: int = ..., first_dep_update: int = ..., cov_type: str = ...): ...

class OrdinalGEEResults(GEEResults):
    __doc__: Any
    def plot_distribution(self, ax: Any | None = ..., exog_values: Any | None = ...): ...

class OrdinalGEEResultsWrapper(GEEResultsWrapper): ...

class NominalGEE(GEE):
    __doc__: Any
    def __init__(self, endog, exog, groups, time: Any | None = ..., family: Any | None = ..., cov_struct: Any | None = ..., missing: str = ..., offset: Any | None = ..., dep_data: Any | None = ..., constraint: Any | None = ..., **kwargs) -> None: ...
    endog_orig: Any
    exog_orig: Any
    groups_orig: Any
    offset_orig: Any
    time_orig: Any
    endog_values: Any
    ncut: Any
    def setup_nominal(self, endog, exog, groups, time, offset): ...
    def mean_deriv(self, exog, lin_pred): ...
    def mean_deriv_exog(self, exog, params, offset_exposure: Any | None = ...): ...
    def fit(self, maxiter: int = ..., ctol: float = ..., start_params: Any | None = ..., params_niter: int = ..., first_dep_update: int = ..., cov_type: str = ...): ...

class NominalGEEResults(GEEResults):
    __doc__: Any
    def plot_distribution(self, ax: Any | None = ..., exog_values: Any | None = ...): ...

class NominalGEEResultsWrapper(GEEResultsWrapper): ...

class _MultinomialLogit(Link):
    ncut: Any
    def __init__(self, ncut) -> None: ...
    def inverse(self, lpr): ...

class _Multinomial(families.Family):
    links: Any
    variance: Any
    safe_links: Any
    def __init__(self, nlevels) -> None: ...
    ncut: Any
    link: Any
    def initialize(self, nlevels) -> None: ...

class GEEMargins:
    results: Any
    def __init__(self, results, args, kwargs=...) -> None: ...
    def tvalues(self): ...
    def summary_frame(self, alpha: float = ...): ...
    def pvalues(self): ...
    def conf_int(self, alpha: float = ...): ...
    def summary(self, alpha: float = ...): ...
    margeff_options: Any
    margeff: Any
    margeff_cov: Any
    margeff_se: Any
    def get_margeff(self, at: str = ..., method: str = ..., atexog: Any | None = ..., dummy: bool = ..., count: bool = ...) -> None: ...
