from statsmodels.compat.pandas import Appender as Appender
from statsmodels.stats.correlation_tools import cov_nearest as cov_nearest
from statsmodels.tools.sm_exceptions import ConvergenceWarning as ConvergenceWarning, NotImplementedWarning as NotImplementedWarning, OutputWarning as OutputWarning
from statsmodels.tools.validation import bool_like as bool_like
from typing import Any

class CovStruct:
    dep_params: Any
    cov_adjust: Any
    cov_nearest_method: Any
    def __init__(self, cov_nearest_method: str = ...) -> None: ...
    model: Any
    def initialize(self, model) -> None: ...
    def update(self, params) -> None: ...
    def covariance_matrix(self, endog_expval, index) -> None: ...
    def covariance_matrix_solve(self, expval, index, stdev, rhs): ...
    def summary(self) -> None: ...

class Independence(CovStruct):
    def update(self, params) -> None: ...
    def covariance_matrix(self, expval, index): ...
    def covariance_matrix_solve(self, expval, index, stdev, rhs): ...
    def summary(self): ...

class Unstructured(CovStruct):
    def __init__(self, cov_nearest_method: str = ...) -> None: ...
    model: Any
    dep_params: Any
    def initialize(self, model) -> None: ...
    def covariance_matrix(self, endog_expval, index): ...
    def update(self, params) -> None: ...
    def summary(self) -> None: ...

class Exchangeable(CovStruct):
    dep_params: float
    def __init__(self) -> None: ...
    def update(self, params) -> None: ...
    def covariance_matrix(self, expval, index): ...
    def covariance_matrix_solve(self, expval, index, stdev, rhs): ...
    def summary(self): ...

class Nested(CovStruct):
    id_matrix: Any
    designx: Any
    ilabels: Any
    designx_u: Any
    designx_s: Any
    designx_v: Any
    def initialize(self, model) -> None: ...
    vcomp_coeff: Any
    scale: Any
    dep_params: Any
    def update(self, params) -> None: ...
    def covariance_matrix(self, expval, index): ...
    def summary(self): ...

class Stationary(CovStruct):
    max_lag: Any
    grid: Any
    dep_params: Any
    def __init__(self, max_lag: int = ..., grid: Any | None = ...) -> None: ...
    time: Any
    def initialize(self, model) -> None: ...
    def update(self, params) -> None: ...
    def update_grid(self, params) -> None: ...
    def update_nogrid(self, params) -> None: ...
    def covariance_matrix(self, endog_expval, index): ...
    def covariance_matrix_grid(self, endog_expval, index): ...
    def covariance_matrix_solve(self, expval, index, stdev, rhs): ...
    def summary(self): ...

class Autoregressive(CovStruct):
    dist_func: Any
    grid: Any
    designx: Any
    dep_params: float
    def __init__(self, dist_func: Any | None = ..., grid: Any | None = ...): ...
    def update(self, params) -> None: ...
    def covariance_matrix(self, endog_expval, index): ...
    def covariance_matrix_solve(self, expval, index, stdev, rhs): ...
    def summary(self): ...

class CategoricalCovStruct(CovStruct):
    nlevel: Any
    ibd: Any
    def initialize(self, model) -> None: ...

class GlobalOddsRatio(CategoricalCovStruct):
    endog_type: Any
    dep_params: float
    def __init__(self, endog_type) -> None: ...
    cpp: Any
    crude_or: Any
    def initialize(self, model) -> None: ...
    def pooled_odds_ratio(self, tables): ...
    def covariance_matrix(self, expected_value, index): ...
    def observed_crude_oddsratio(self): ...
    def get_eyy(self, endog_expval, index): ...
    def update(self, params) -> None: ...
    def summary(self): ...

class OrdinalIndependence(CategoricalCovStruct):
    def covariance_matrix(self, expected_value, index): ...
    def update(self, params) -> None: ...

class NominalIndependence(CategoricalCovStruct):
    def covariance_matrix(self, expected_value, index): ...
    def update(self, params) -> None: ...

class Equivalence(CovStruct):
    pairs: Any
    labels: Any
    return_cov: Any
    def __init__(self, pairs: Any | None = ..., labels: Any | None = ..., return_cov: bool = ...) -> None: ...
    dep_params: Any
    def initialize(self, model): ...
    n_pairs: Any
    def update(self, params): ...
    def covariance_matrix(self, expval, index): ...
