from statsmodels.base._penalized import PenalizedMixin as PenalizedMixin
from statsmodels.discrete.discrete_model import Logit as Logit
from statsmodels.gam.gam_cross_validation.cross_validators import KFold as KFold
from statsmodels.gam.gam_cross_validation.gam_cross_validation import MultivariateGAMCVPath as MultivariateGAMCVPath
from statsmodels.gam.gam_penalties import MultivariateGamPenalty as MultivariateGamPenalty
from statsmodels.genmod.generalized_linear_model import GLM as GLM, GLMResults as GLMResults, GLMResultsWrapper as GLMResultsWrapper
from statsmodels.tools.decorators import cache_readonly as cache_readonly
from statsmodels.tools.linalg import matrix_sqrt as matrix_sqrt
from statsmodels.tools.sm_exceptions import PerfectSeparationError as PerfectSeparationError, ValueWarning as ValueWarning
from typing import Any

class GLMGamResults(GLMResults):
    model: Any
    params: Any
    normalized_cov_params: Any
    scale: Any
    df_model: Any
    df_resid: Any
    def __init__(self, model, params, normalized_cov_params, scale, **kwds) -> None: ...
    def predict(self, exog: Any | None = ..., exog_smooth: Any | None = ..., transform: bool = ..., **kwargs): ...
    def get_prediction(self, exog: Any | None = ..., exog_smooth: Any | None = ..., transform: bool = ..., **kwargs): ...
    def partial_values(self, smooth_index, include_constant: bool = ...): ...
    def plot_partial(self, smooth_index, plot_se: bool = ..., cpr: bool = ..., include_constant: bool = ..., ax: Any | None = ...): ...
    def test_significance(self, smooth_index): ...
    def get_hat_matrix_diag(self, observed: bool = ..., _axis: int = ...): ...
    def edf(self): ...
    def hat_matrix_trace(self): ...
    def hat_matrix_diag(self): ...
    def gcv(self): ...
    def cv(self): ...

class GLMGamResultsWrapper(GLMResultsWrapper): ...

class GLMGam(PenalizedMixin, GLM):
    design_info_linear: Any
    data_linear: Any
    k_exog_linear: Any
    exog_linear: Any
    smoother: Any
    k_smooths: Any
    alpha: Any
    formula_linear: Any
    formula: Any
    def __init__(self, endog, exog: Any | None = ..., smoother: Any | None = ..., alpha: int = ..., family: Any | None = ..., offset: Any | None = ..., exposure: Any | None = ..., missing: str = ..., **kwargs) -> None: ...
    def fit(self, start_params: Any | None = ..., maxiter: int = ..., method: str = ..., tol: float = ..., scale: Any | None = ..., cov_type: str = ..., cov_kwds: Any | None = ..., use_t: Any | None = ..., full_output: bool = ..., disp: bool = ..., max_start_irls: int = ..., **kwargs): ...
    scale: Any
    scaletype: Any
    def select_penweight(self, criterion: str = ..., start_params: Any | None = ..., start_model_params: Any | None = ..., method: str = ..., **fit_kwds): ...
    def select_penweight_kfold(self, alphas: Any | None = ..., cv_iterator: Any | None = ..., cost: Any | None = ..., k_folds: int = ..., k_grid: int = ...): ...

class LogitGam(PenalizedMixin, Logit):
    smoother: Any
    alpha: Any
    pen_weight: int
    def __init__(self, endog, smoother, alpha, *args, **kwargs) -> None: ...

def penalized_wls(endog, exog, penalty_matrix, weights): ...
def make_augmented_matrix(endog, exog, penalty_matrix, weights): ...
