from statsmodels.compat.scipy import multivariate_t as multivariate_t
from statsmodels.distributions.copula.copulas import Copula as Copula
from typing import Any

class EllipticalCopula(Copula):
    def rvs(self, nobs: int = ..., args=..., random_state: Any | None = ...): ...
    def pdf(self, u, args=...): ...
    def cdf(self, u, args=...): ...
    def tau(self, corr: Any | None = ...): ...
    def corr_from_tau(self, tau): ...

class GaussianCopula(EllipticalCopula):
    corr: Any
    distr_uv: Any
    distr_mv: Any
    def __init__(self, corr: Any | None = ..., k_dim: int = ...) -> None: ...
    def dependence_tail(self, corr: Any | None = ...): ...

class StudentTCopula(EllipticalCopula):
    df: Any
    corr: Any
    distr_uv: Any
    distr_mv: Any
    def __init__(self, corr: Any | None = ..., df: Any | None = ..., k_dim: int = ...) -> None: ...
    def cdf(self, u, args=...) -> None: ...
    def spearmans_rho(self, corr: Any | None = ...): ...
    def dependence_tail(self, corr: Any | None = ...): ...
