from statsmodels.tools.numdiff import approx_hess as approx_hess
from typing import Any

class PickandDependence:
    def __call__(self, *args, **kwargs): ...
    def evaluate(self, t, *args) -> None: ...
    def deriv(self, t, *args): ...
    def deriv2(self, t, *args): ...

class AsymLogistic(PickandDependence):
    k_args: int
    def evaluate(self, t, a1, a2, theta): ...
    def deriv(self, t, a1, a2, theta): ...
    def deriv2(self, t, a1, a2, theta): ...

transform_tawn: Any

class AsymNegLogistic(PickandDependence):
    k_args: int
    def evaluate(self, t, a1, a2, theta): ...
    def deriv(self, t, a1, a2, theta): ...
    def deriv2(self, t, a1, a2, theta): ...

transform_joe: Any

class AsymMixed(PickandDependence):
    k_args: int
    def evaluate(self, t, theta, k): ...
    def deriv(self, t, theta, k): ...
    def deriv2(self, t, theta, k): ...

transform_tawn2: Any

class AsymBiLogistic(PickandDependence):
    k_args: int
    def evaluate(self, t, beta, delta): ...

transform_bilogistic: Any

class HR(PickandDependence):
    k_args: int
    def evaluate(self, t, lamda): ...
    def deriv(self, t, lamda): ...
    def deriv2(self, t, lamda): ...

transform_hr: Any

class TEV(PickandDependence):
    k_args: int
    def evaluate(self, t, rho, df): ...

transform_tev: Any
