import abc
from abc import ABC, abstractmethod
from statsmodels.graphics import utils as utils
from typing import Any

class CopulaDistribution:
    copula: Any
    marginals: Any
    cop_args: Any
    k_vars: Any
    def __init__(self, copula, marginals, cop_args=...) -> None: ...
    def rvs(self, nobs: int = ..., cop_args: Any | None = ..., marg_args: Any | None = ..., random_state: Any | None = ...): ...
    def cdf(self, y, cop_args: Any | None = ..., marg_args: Any | None = ...): ...
    def pdf(self, y, cop_args: Any | None = ..., marg_args: Any | None = ...): ...
    def logpdf(self, y, cop_args: Any | None = ..., marg_args: Any | None = ...): ...

class Copula(ABC, metaclass=abc.ABCMeta):
    k_dim: Any
    def __init__(self, k_dim: int = ...) -> None: ...
    def rvs(self, nobs: int = ..., args=..., random_state: Any | None = ...) -> None: ...
    @abstractmethod
    def pdf(self, u, args=...): ...
    def logpdf(self, u, args=...): ...
    @abstractmethod
    def cdf(self, u, args=...): ...
    def plot_scatter(self, sample: Any | None = ..., nobs: int = ..., random_state: Any | None = ..., ax: Any | None = ...): ...
    def plot_pdf(self, ticks_nbr: int = ..., ax: Any | None = ...): ...
    def tau_simulated(self, nobs: int = ..., random_state: Any | None = ...): ...
    def fit_corr_param(self, data): ...
