from . import transforms as transforms
from .copulas import Copula as Copula
from statsmodels.tools.rng_qrng import check_random_state as check_random_state
from typing import Any

class ArchimedeanCopula(Copula):
    args: Any
    transform: Any
    k_args: int
    def __init__(self, transform, args=..., k_dim: int = ...) -> None: ...
    def cdf(self, u, args=...): ...
    def pdf(self, u, args=...): ...
    def logpdf(self, u, args=...): ...

class ClaytonCopula(ArchimedeanCopula):
    theta: Any
    def __init__(self, theta: Any | None = ..., k_dim: int = ...) -> None: ...
    def rvs(self, nobs: int = ..., args=..., random_state: Any | None = ...): ...
    def pdf(self, u, args=...): ...
    def logpdf(self, u, args=...): ...
    def cdf(self, u, args=...): ...
    def tau(self, theta: Any | None = ...): ...
    def theta_from_tau(self, tau): ...

class FrankCopula(ArchimedeanCopula):
    theta: Any
    def __init__(self, theta: Any | None = ..., k_dim: int = ...) -> None: ...
    def rvs(self, nobs: int = ..., args=..., random_state: Any | None = ...): ...
    def pdf(self, u, args=...): ...
    def cdf(self, u, args=...): ...
    def logpdf(self, u, args=...): ...
    def cdfcond_2g1(self, u, args=...): ...
    def ppfcond_2g1(self, q, u1, args=...): ...
    def tau(self, theta: Any | None = ...): ...
    def theta_from_tau(self, tau): ...

class GumbelCopula(ArchimedeanCopula):
    theta: Any
    def __init__(self, theta: Any | None = ..., k_dim: int = ...) -> None: ...
    def rvs(self, nobs: int = ..., args=..., random_state: Any | None = ...): ...
    def pdf(self, u, args=...): ...
    def cdf(self, u, args=...): ...
    def logpdf(self, u, args=...): ...
    def tau(self, theta: Any | None = ...): ...
    def theta_from_tau(self, tau): ...
